/*
 * Decompiled with CFR 0.152.
 */
package com.gomyck.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.servlet.http.HttpServletRequest;

public abstract class CkIp {
    public static String getRemoteAddr(HttpServletRequest request) {
        String ip = request.getHeader("X-Forwarded-For");
        if (ip != null && !ip.trim().equals("") && !"unknown".equalsIgnoreCase(ip)) {
            int index = ip.indexOf(44);
            if (index != -1) {
                return ip.substring(0, index);
            }
            return ip;
        }
        ip = request.getHeader("X-Real-IP");
        if (ip != null && !ip.trim().equals("") && !"unknown".equalsIgnoreCase(ip)) {
            return ip;
        }
        return request.getRemoteAddr();
    }

    public static boolean isRealIp(String ip) {
        String pattern = "^([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])$";
        return ip.matches(pattern);
    }

    public static String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return "unknow";
        }
    }

    public static String getHostAddress() {
        try {
            try {
                return InetAddress.getByName("host.docker.internal").getHostAddress();
            }
            catch (Exception e) {
                return InetAddress.getLocalHost().getHostAddress();
            }
        }
        catch (UnknownHostException e) {
            return "unknow";
        }
    }
}

