/*
 * Decompiled with CFR 0.152.
 */
package com.gomyck.util;

import com.gomyck.util.DataFilter;
import com.gomyck.util.ObjectJudge;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Objects;
import java.util.Stack;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public abstract class CkMath {
    static final String zhnum_0 = "\u96f6\u58f9\u8d30\u53c1\u8086\u4f0d\u9646\u67d2\u634c\u7396";
    static final String zhnum = "\u96f6\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d";
    static final String[] zhnum1 = new String[]{"", "\u5341", "\u767e", "\u5343"};
    static final String[] zhnum1_0 = new String[]{"", "\u62fe", "\u4f70", "\u4edf"};
    static final String[] zhnum2 = new String[]{"", "\u4e07", "\u4ebf", "\u4e07\u4ebf", "\u4ebf\u4ebf"};

    public static boolean compare(String num1, String num2) {
        double _num1 = 0.0;
        double _num2 = 0.0;
        try {
            _num1 = Double.parseDouble(num1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            _num2 = Double.parseDouble(num2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return _num1 > _num2;
    }

    public static String plus2String(String ... num) {
        return DataFilter.toString(Stream.of(num).map(e -> Objects.requireNonNull(DataFilter.getFirstNotNull(e, "0")).toString()).mapToInt(Integer::parseInt).sum());
    }

    public static int plus2Int(String ... num) {
        return Stream.of(num).mapToInt(Integer::parseInt).sum();
    }

    private static String numberToZH4Str(String s, boolean fan) {
        StringBuilder sb = new StringBuilder();
        if (s.length() != 4) {
            return null;
        }
        for (int i = 0; i < 4; ++i) {
            char c1 = s.charAt(i);
            if (c1 == '0' && i > 1 && s.charAt(i - 1) == '0') continue;
            if (c1 != '0' && i > 1 && s.charAt(i - 1) == '0') {
                sb.append('\u96f6');
            }
            if (c1 == '0') continue;
            if (fan) {
                sb.append(zhnum_0.charAt(c1 - 48));
                sb.append(zhnum1_0[4 - i - 1]);
                continue;
            }
            sb.append(zhnum.charAt(c1 - 48));
            sb.append(zhnum1[4 - i - 1]);
        }
        return new String(sb);
    }

    public static String numberToZH(long n, boolean fan) {
        StringBuilder sb = new StringBuilder();
        String strN = "000" + n;
        int strN_L = strN.length() / 4;
        strN = strN.substring(strN.length() - strN_L * 4);
        for (int i = 0; i < strN_L; ++i) {
            String s1 = strN.substring(i * 4, i * 4 + 4);
            String s2 = CkMath.numberToZH4Str(s1, fan);
            sb.append(s2);
            if (s2.length() == 0) continue;
            sb.append(zhnum2[strN_L - i - 1]);
        }
        String s = new String(sb);
        if (s.startsWith("\u96f6")) {
            s = s.substring(1);
        }
        return s;
    }

    public static String numberToZH(double d, boolean fan) {
        return CkMath.numberToZH("" + d, fan);
    }

    public static String numberToZH(String str, boolean fan) {
        String s;
        StringBuilder sb = new StringBuilder();
        int dot = str.indexOf(".");
        if (dot < 0) {
            dot = str.length();
        }
        String zhengshu = str.substring(0, dot);
        sb.append(CkMath.numberToZH(Long.parseLong(zhengshu), fan));
        if (dot != str.length()) {
            sb.append("\u70b9");
            String xiaoshu = str.substring(dot + 1);
            for (int i = 0; i < xiaoshu.length(); ++i) {
                if (fan) {
                    sb.append(zhnum_0.charAt(Integer.parseInt(xiaoshu.substring(i, i + 1))));
                    continue;
                }
                sb.append(zhnum.charAt(Integer.parseInt(xiaoshu.substring(i, i + 1))));
            }
        }
        if ((s = new String(sb)).startsWith("\u96f6")) {
            s = s.substring(1);
        }
        if (s.startsWith("\u4e00\u5341")) {
            s = s.substring(1);
        }
        while (s.endsWith("\u96f6")) {
            s = s.substring(0, s.length() - 1);
        }
        if (s.endsWith("\u70b9")) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public static String numberToRMB(double rmb) {
        String strRMB = "" + rmb;
        DecimalFormat nf = new DecimalFormat("#.#");
        nf.setMaximumFractionDigits(2);
        strRMB = nf.format(rmb).toString();
        strRMB = CkMath.numberToZH(strRMB, true);
        if (strRMB.indexOf("\u70b9") >= 0) {
            strRMB = strRMB + "\u96f6";
            strRMB = strRMB.replaceAll("\u70b9", "\u5706");
            String s1 = strRMB.substring(0, strRMB.indexOf("\u5706") + 1);
            String s2 = strRMB.substring(strRMB.indexOf("\u5706") + 1);
            strRMB = s1 + s2.charAt(0) + "\u89d2" + s2.charAt(1) + "\u5206\u6574";
        } else {
            strRMB = strRMB + "\u5706\u6574";
        }
        return "\u4eba\u6c11\u5e01(\u5927\u5199):" + strRMB;
    }

    public static String execExpress(String expr) {
        Stack<String> number = new Stack<String>();
        Stack<String> operator = new Stack<String>();
        operator.push(null);
        Pattern p = Pattern.compile("(?<!\\d)-?\\d+(\\.\\d+)?|[+\\-*/()]");
        Matcher m = p.matcher(expr);
        while (m.find()) {
            String temp = m.group();
            if (temp.matches("[+\\-*/()]")) {
                if (temp.equals("(")) {
                    operator.push(temp);
                    continue;
                }
                if (temp.equals(")")) {
                    String b;
                    while (!(b = (String)operator.pop()).equals("(")) {
                        CkMath.popAndCompute(number, b.charAt(0));
                    }
                    continue;
                }
                while (CkMath.getPriority(temp) <= CkMath.getPriority((String)operator.peek())) {
                    CkMath.popAndCompute(number, ((String)operator.pop()).charAt(0));
                }
                operator.push(temp);
                continue;
            }
            number.push(temp);
        }
        while (operator.peek() != null) {
            CkMath.popAndCompute(number, ((String)operator.pop()).charAt(0));
        }
        return (String)number.pop();
    }

    public static BiFunction<String, String, BigDecimal> add() {
        return (e1, e2) -> {
            if (ObjectJudge.hasNull(e1, e2)) {
                throw new IllegalArgumentException("Adding Numbers is not allowed to be null !");
            }
            BigDecimal left = new BigDecimal((String)e1);
            BigDecimal right = new BigDecimal((String)e2);
            return left.add(right);
        };
    }

    public static BiFunction<String, String, BigDecimal> sub() {
        return (e1, e2) -> {
            if (ObjectJudge.hasNull(e1, e2)) {
                throw new IllegalArgumentException("Subtracting Numbers is not allowed to be null !");
            }
            BigDecimal left = new BigDecimal((String)e1);
            BigDecimal right = new BigDecimal((String)e2);
            return left.subtract(right);
        };
    }

    public static BiFunction<String, String, BigDecimal> mul() {
        return (e1, e2) -> {
            if (ObjectJudge.hasNull(e1, e2)) {
                throw new IllegalArgumentException("Multiplying Numbers is not allowed to be null !");
            }
            BigDecimal left = new BigDecimal((String)e1);
            BigDecimal right = new BigDecimal((String)e2);
            return left.multiply(right);
        };
    }

    public static BiFunction<String, String, BigDecimal> div() {
        return (e1, e2) -> {
            if (ObjectJudge.hasNull(e1, e2)) {
                throw new IllegalArgumentException("Dividing Numbers is not allowed to be null !");
            }
            BigDecimal left = new BigDecimal((String)e1);
            BigDecimal right = new BigDecimal((String)e2);
            return left.divide(right, 4);
        };
    }

    private static String compute(String a1, String a2, char operator) {
        switch (operator) {
            case '+': {
                return CkMath.add().apply(a1, a2).toString();
            }
            case '-': {
                return CkMath.sub().apply(a1, a2).toString();
            }
            case '*': {
                return CkMath.mul().apply(a1, a2).toString();
            }
            case '/': {
                return CkMath.div().apply(a1, a2).toString();
            }
        }
        throw new RuntimeException("illegal operator!");
    }

    private static int getPriority(String s) {
        if (s == null) {
            return 0;
        }
        switch (s) {
            case "(": {
                return 1;
            }
            case "+": 
            case "-": {
                return 2;
            }
            case "*": 
            case "/": {
                return 3;
            }
        }
        throw new RuntimeException("illegal operator!");
    }

    private static void popAndCompute(Stack<String> number, char operator) {
        String a1 = number.pop();
        String a2 = number.pop();
        number.push(CkMath.compute(a2, a1, operator));
    }
}

