/*
 * Decompiled with CFR 0.152.
 */
package com.gomyck.util;

import com.gomyck.util.ObjectJudge;
import java.util.Comparator;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DataFilter {
    private static final Pattern compile = Pattern.compile("[^(a-zA-Z\\d_\\u4e00-\\u9fa5)]");

    public static String toString(Object param) {
        if (ObjectJudge.isNull(param)) {
            return "";
        }
        String str = param.toString().trim();
        Pattern p = Pattern.compile("[\t\r\n]");
        Matcher m = p.matcher(str);
        return m.replaceAll("");
    }

    public static String toStringNoFilter(Object param) {
        if (ObjectJudge.isNull(param)) {
            return "";
        }
        return param.toString().trim();
    }

    public static String illegalFilter(String param) {
        return DataFilter.illegalFilter(compile, param);
    }

    public static String illegalFilter(Pattern compile, String param) {
        if (ObjectJudge.isNull((Object)param)) {
            return "";
        }
        return compile.matcher(param).replaceAll("").trim();
    }

    public static byte[] subByte(byte[] source, int start, int length) {
        byte[] dist = new byte[length];
        System.arraycopy(source, start, dist, 0, length);
        return dist;
    }

    public static Object getFirstNotNull(Object ... objs) {
        if (ObjectJudge.isNull(objs)) {
            throw new RuntimeException("you must promise the last param is not null!!");
        }
        for (Object obj : objs) {
            if (!ObjectJudge.notNull(obj)) continue;
            return obj;
        }
        return objs[0];
    }

    public static Object getDataByFunc(Function<Object, Boolean> func, Object ... objs) {
        if (ObjectJudge.isNull(objs)) {
            return null;
        }
        for (Object obj : objs) {
            if (!func.apply(obj).booleanValue()) continue;
            return obj;
        }
        return objs[0];
    }

    public static <T> Comparator<T> dicComparator() {
        return (e1, e2) -> {
            int i;
            if (e1 == null) {
                return -1;
            }
            if (e2 == null) {
                return 1;
            }
            char[] chars1 = e1.toString().toCharArray();
            char[] chars2 = e2.toString().toCharArray();
            for (i = 0; i < chars1.length && i < chars2.length; ++i) {
                if (chars1[i] > chars2[i]) {
                    return 1;
                }
                if (chars1[i] >= chars2[i]) continue;
                return -1;
            }
            if (i == chars1.length) {
                return -1;
            }
            if (i == chars2.length) {
                return 1;
            }
            return 0;
        };
    }

    public static String replaceLast(String str, String match, String replace) {
        if (ObjectJudge.isNull((Object)str) || null == replace) {
            return str;
        }
        StringBuilder sBuilder = new StringBuilder(str);
        int lastIndexOf = sBuilder.lastIndexOf(match);
        if (-1 == lastIndexOf) {
            return str;
        }
        return sBuilder.replace(lastIndexOf, lastIndexOf + match.length(), replace).toString();
    }
}

