/*
 * Decompiled with CFR 0.152.
 */
package com.gomyck.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import org.springframework.core.io.ClassPathResource;

public class PropertiesReader {
    private static final String CLASSPATH = "classpath";

    private PropertiesReader() {
    }

    public static Properties initProperties(String filePath) throws IOException {
        Properties prop = new Properties();
        if (filePath.contains(CLASSPATH)) {
            filePath = filePath.replace("*", "").replace("classpath:", "");
            ClassPathResource cpr = new ClassPathResource(filePath);
            InputStream is = cpr.getInputStream();
            prop.load(is);
        } else {
            prop.load(new FileInputStream(filePath));
        }
        return prop;
    }

    public String getValue(String file_name, String key) throws MissingResourceException {
        ResourceBundle res = ResourceBundle.getBundle(file_name);
        String value = res.getString(key);
        return value;
    }
}

