/*
 * Decompiled with CFR 0.152.
 */
package com.gomyck.util;

import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.gomyck.util.CkPage;
import com.gomyck.util.CkParam;
import com.gomyck.util.ObjectJudge;
import com.gomyck.util.xss.SQLFilter;
import java.util.LinkedHashMap;
import java.util.Map;

public class Query<T>
extends LinkedHashMap<String, Object> {
    private static final long serialVersionUID = 1L;
    private final Page<T> page;
    private int currPage = 1;
    private int limit = 10;

    public Query(Map<String, Object> params) {
        this.putAll(params);
        if (params.get("page") != null) {
            this.currPage = Integer.parseInt(params.get("page") + "");
        }
        if (params.get("limit") != null) {
            this.limit = Integer.parseInt(params.get("limit") + "");
        }
        this.put("offset", (this.currPage - 1) * this.limit);
        this.put("page", this.currPage);
        this.put("limit", this.limit);
        String sidx = SQLFilter.sqlInject(params.get("sidx") + "");
        String order = SQLFilter.sqlInject(params.get("order") + "");
        this.put("sidx", sidx);
        this.put("order", order);
        this.page = new Page((long)this.currPage, (long)this.limit);
        if (!ObjectJudge.isNull((Object)sidx) && !ObjectJudge.isNull((Object)order)) {
            OrderItem orderItem = "ASC".equalsIgnoreCase(order) ? OrderItem.asc((String)sidx) : OrderItem.desc((String)sidx);
            this.page.addOrder(new OrderItem[]{orderItem});
        }
    }

    public Query(CkPage.PageInfo pageInfo) {
        this(CkParam.initParams(pageInfo));
    }

    public Page<T> getPage() {
        return this.page;
    }

    public int getCurrPage() {
        return this.currPage;
    }

    public int getLimit() {
        return this.limit;
    }
}

