/*
 * Decompiled with CFR 0.152.
 */
package com.gomyck.util;

import com.gomyck.util.log.logger.CkLogger;
import java.net.NetworkInterface;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemUtil {
    private static final Logger log = LoggerFactory.getLogger(SystemUtil.class);

    private static String getMacCode() {
        try {
            Enumeration<NetworkInterface> el = NetworkInterface.getNetworkInterfaces();
            while (el.hasMoreElements()) {
                byte[] mac = el.nextElement().getHardwareAddress();
                if (mac == null) continue;
                StringBuilder stringBuilder = new StringBuilder();
                if (mac.length <= 0) {
                    return null;
                }
                for (int i = 0; i < mac.length; ++i) {
                    int v = mac[i] & 0xFF;
                    String hv = Integer.toHexString(v);
                    if (hv.length() < 2) {
                        stringBuilder.append(0);
                    }
                    stringBuilder.append(hv);
                }
                return stringBuilder.toString().toUpperCase();
            }
        }
        catch (Exception exception) {
            log.error(CkLogger.getTrace(exception));
        }
        return null;
    }

    public static String getMachineCode() {
        HashSet<String> result = new HashSet<String>();
        String mac = SystemUtil.getMacCode();
        result.add(mac);
        Properties props = System.getProperties();
        String javaVersion = props.getProperty("java.version");
        result.add(javaVersion);
        String javaVMVersion = props.getProperty("java.vm.version");
        result.add(javaVMVersion);
        String osVersion = props.getProperty("os.version");
        result.add(osVersion);
        StringBuffer sb = new StringBuffer();
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] digest = md.digest(((Object)result).toString().getBytes());
            for (int i = 0; i < digest.length; ++i) {
                sb.append(Integer.toHexString(digest[i] & 0xFF | 0x100).toUpperCase().substring(1, 3));
            }
        }
        catch (NoSuchAlgorithmException e) {
            log.error(CkLogger.getTrace(e));
        }
        return sb.toString();
    }
}

