/*
 * Decompiled with CFR 0.152.
 */
package com.gomyck.util;

import com.gomyck.util.FieldUtil;
import com.gomyck.util.log.logger.CkLogger;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlParser {
    private static final Logger log = LoggerFactory.getLogger(XmlParser.class);
    private static final XmlParser xp = new XmlParser();
    private static final ThreadLocal<Document> doc = new ThreadLocal();

    private XmlParser() {
    }

    public static XmlParser parseXml(String xmlBody) {
        try {
            DocumentBuilderFactory _dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder _db = _dbf.newDocumentBuilder();
            Document _doc = _db.parse(new ByteArrayInputStream(xmlBody.getBytes()));
            doc.set(_doc);
        }
        catch (Exception e) {
            log.error(CkLogger.getTrace(e));
            return null;
        }
        return xp;
    }

    public static XmlParser parseXml(File xmlBody) {
        try {
            return XmlParser.parseXml(new FileInputStream(xmlBody));
        }
        catch (FileNotFoundException e) {
            log.error(CkLogger.getTrace(e));
            return null;
        }
    }

    public static XmlParser parseXml(InputStream xmlBody) {
        try {
            DocumentBuilderFactory _dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder _db = _dbf.newDocumentBuilder();
            Document _doc = _db.parse(xmlBody);
            doc.set(_doc);
        }
        catch (Exception e) {
            log.error(CkLogger.getTrace(e));
            return null;
        }
        return xp;
    }

    public <T> T convertEntity(Class<T> clazz) {
        try {
            T target = clazz.newInstance();
            List<Field> fields = FieldUtil.getAllFields(clazz);
            for (Field field : fields) {
                Method method = FieldUtil.setMethod(clazz, field.getName());
                try {
                    method.invoke(target, XmlParser.getNodeValue(field.getName()));
                }
                catch (Exception ignore) {
                    log.warn("field: " + field.getName() + " could has not setter.");
                }
            }
            return target;
        }
        catch (Exception e) {
            log.error(CkLogger.getTrace(e));
            return null;
        }
    }

    private static String getNodeValue(String tagName) {
        NodeList _nl = doc.get().getElementsByTagName(tagName);
        if (_nl == null) {
            return "";
        }
        Node _node = _nl.item(0);
        if (_node == null) {
            return "";
        }
        return _node.getTextContent() == null ? "" : _node.getTextContent().trim();
    }
}

