/*
 * Decompiled with CFR 0.152.
 */
package com.gomyck.util.datasources;

import com.alibaba.druid.pool.DruidDataSource;
import com.gomyck.util.AutoConfig;
import com.gomyck.util.datasources.CkDataSourceRouter;
import com.gomyck.util.datasources.DBIndex;
import com.gomyck.util.datasources.annotation.DBManager;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Primary;
import org.springframework.core.Ordered;

@Aspect
@Configuration
public class DataSourceAutoConfig
implements Ordered,
AutoConfig {
    private static final Logger log = LoggerFactory.getLogger(DataSourceAutoConfig.class);
    private final Map<Object, Object> targetDataSources = new HashMap<Object, Object>();
    public static final String CK_PREFIX_DB1 = "spring.datasource.druid.db1";
    public static final String CK_PREFIX_DB2 = "spring.datasource.druid.db2";
    public static final String CK_PREFIX_DB3 = "spring.datasource.druid.db3";
    public static final String CK_PREFIX_DB4 = "spring.datasource.druid.db4";
    public static final String CK_PREFIX_DB5 = "spring.datasource.druid.db5";
    public static final String CK_PREFIX_DB6 = "spring.datasource.druid.db6";
    public static final String CK_PREFIX_DB7 = "spring.datasource.druid.db7";
    public static final String CK_PREFIX_DB8 = "spring.datasource.druid.db8";
    public static final String CK_PREFIX_DB9 = "spring.datasource.druid.db9";

    @Bean
    @ConfigurationProperties(value="spring.datasource.druid.db1")
    public DataSource db1DataSource() {
        DruidDataSource druidDataSource = new DruidDataSource();
        this.targetDataSources.put((Object)DBIndex.DB1, druidDataSource);
        return druidDataSource;
    }

    @Bean
    @ConfigurationProperties(value="spring.datasource.druid.db2")
    @ConditionalOnProperty(prefix="spring.datasource.druid.db2", name={"url"})
    public DataSource db2DataSource(CkDataSourceRouter initMainDataSource) {
        DruidDataSource druidDataSource = new DruidDataSource();
        this.targetDataSources.put((Object)DBIndex.DB2, druidDataSource);
        initMainDataSource.refresh((DataSource)this.targetDataSources.get((Object)DBIndex.DB1), this.targetDataSources);
        return druidDataSource;
    }

    @Bean
    @ConfigurationProperties(value="spring.datasource.druid.db3")
    @ConditionalOnProperty(prefix="spring.datasource.druid.db3", name={"url"})
    public DataSource db3DataSource(CkDataSourceRouter initMainDataSource) {
        DruidDataSource druidDataSource = new DruidDataSource();
        this.targetDataSources.put((Object)DBIndex.DB3, druidDataSource);
        initMainDataSource.refresh((DataSource)this.targetDataSources.get((Object)DBIndex.DB1), this.targetDataSources);
        return druidDataSource;
    }

    @Bean
    @ConfigurationProperties(value="spring.datasource.druid.db4")
    @ConditionalOnProperty(prefix="spring.datasource.druid.db4", name={"url"})
    public DataSource db4DataSource(CkDataSourceRouter initMainDataSource) {
        DruidDataSource druidDataSource = new DruidDataSource();
        this.targetDataSources.put((Object)DBIndex.DB4, druidDataSource);
        initMainDataSource.refresh((DataSource)this.targetDataSources.get((Object)DBIndex.DB1), this.targetDataSources);
        return druidDataSource;
    }

    @Bean
    @ConfigurationProperties(value="spring.datasource.druid.db5")
    @ConditionalOnProperty(prefix="spring.datasource.druid.db5", name={"url"})
    public DataSource db5DataSource(CkDataSourceRouter initMainDataSource) {
        DruidDataSource druidDataSource = new DruidDataSource();
        this.targetDataSources.put((Object)DBIndex.DB5, druidDataSource);
        initMainDataSource.refresh((DataSource)this.targetDataSources.get((Object)DBIndex.DB1), this.targetDataSources);
        return druidDataSource;
    }

    @Bean
    @ConfigurationProperties(value="spring.datasource.druid.db6")
    @ConditionalOnProperty(prefix="spring.datasource.druid.db6", name={"url"})
    public DataSource db6DataSource(CkDataSourceRouter initMainDataSource) {
        DruidDataSource druidDataSource = new DruidDataSource();
        this.targetDataSources.put((Object)DBIndex.DB6, druidDataSource);
        initMainDataSource.refresh((DataSource)this.targetDataSources.get((Object)DBIndex.DB1), this.targetDataSources);
        return druidDataSource;
    }

    @Bean
    @ConfigurationProperties(value="spring.datasource.druid.db7")
    @ConditionalOnProperty(prefix="spring.datasource.druid.db7", name={"url"})
    public DataSource db7DataSource(CkDataSourceRouter initMainDataSource) {
        DruidDataSource druidDataSource = new DruidDataSource();
        this.targetDataSources.put((Object)DBIndex.DB7, druidDataSource);
        initMainDataSource.refresh((DataSource)this.targetDataSources.get((Object)DBIndex.DB1), this.targetDataSources);
        return druidDataSource;
    }

    @Bean
    @ConfigurationProperties(value="spring.datasource.druid.db8")
    @ConditionalOnProperty(prefix="spring.datasource.druid.db8", name={"url"})
    public DataSource db8DataSource(CkDataSourceRouter initMainDataSource) {
        DruidDataSource druidDataSource = new DruidDataSource();
        this.targetDataSources.put((Object)DBIndex.DB8, druidDataSource);
        initMainDataSource.refresh((DataSource)this.targetDataSources.get((Object)DBIndex.DB1), this.targetDataSources);
        return druidDataSource;
    }

    @Bean
    @ConfigurationProperties(value="spring.datasource.druid.db9")
    @ConditionalOnProperty(prefix="spring.datasource.druid.db9", name={"url"})
    public DataSource db9DataSource(CkDataSourceRouter initMainDataSource) {
        DruidDataSource druidDataSource = new DruidDataSource();
        this.targetDataSources.put((Object)DBIndex.DB9, druidDataSource);
        initMainDataSource.refresh((DataSource)this.targetDataSources.get((Object)DBIndex.DB1), this.targetDataSources);
        return druidDataSource;
    }

    @Primary
    @Bean
    @DependsOn(value={"db1DataSource"})
    public CkDataSourceRouter initMainDataSource() {
        return new CkDataSourceRouter((DataSource)this.targetDataSources.get((Object)DBIndex.DB1), this.targetDataSources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="@annotation(com.gomyck.util.datasources.annotation.DBManager)")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        MethodSignature signature = (MethodSignature)point.getSignature();
        Method method = signature.getMethod();
        DBManager ds = method.getAnnotation(DBManager.class);
        CkDataSourceRouter.setDBIndex(ds.dbIndex());
        log.debug("set datasource index is " + ds.dbIndex().name());
        try {
            Object object = point.proceed();
            return object;
        }
        finally {
            CkDataSourceRouter.clearDBIndex();
            log.debug("clean datasource index info");
        }
    }

    public int getOrder() {
        return 1;
    }
}

