/*
 * Decompiled with CFR 0.152.
 */
package com.gomyck.util.digest;

import com.gomyck.util.log.logger.CkLogger;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Iterator;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPCompressedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPOnePassSignatureList;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyEncryptedData;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.PGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.PGPKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.PublicKeyDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyDecryptorBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePublicKeyDataDecryptorFactoryBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePublicKeyKeyEncryptionMethodGenerator;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgpUtil {
    private static final Logger log = LoggerFactory.getLogger(PgpUtil.class);
    private static PgpUtil INSTANCE;

    public static PgpUtil getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PgpUtil();
        }
        return INSTANCE;
    }

    private PgpUtil() {
    }

    private PGPSecretKey findSecretKey(InputStream input) throws Exception {
        PGPSecretKeyRingCollection pgpSec = new PGPSecretKeyRingCollection(PGPUtil.getDecoderStream((InputStream)input), (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
        Iterator keyRings = pgpSec.getKeyRings();
        while (keyRings.hasNext()) {
            PGPSecretKeyRing keyRing = (PGPSecretKeyRing)keyRings.next();
            Iterator keyIter = keyRing.getSecretKeys();
            while (keyIter.hasNext()) {
                PGPSecretKey key = (PGPSecretKey)keyIter.next();
                if (!key.isSigningKey()) continue;
                return key;
            }
        }
        throw new IllegalArgumentException("Can't find signing key in key ring.");
    }

    private PGPPublicKey findPublicKey(long keyId, InputStream in) throws Exception {
        PGPPublicKeyRing keyRing;
        PGPPublicKey publicKey;
        in = PGPUtil.getDecoderStream((InputStream)in);
        PGPPublicKeyRingCollection pubRingCollection = new PGPPublicKeyRingCollection(PGPUtil.getDecoderStream((InputStream)in), (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
        UnmodifiableIterator var4 = ImmutableList.copyOf((Iterator)pubRingCollection.getKeyRings()).iterator();
        do {
            if (var4.hasNext()) continue;
            throw new RuntimeException("Could not find a public key matching the signature in provided key file");
        } while ((publicKey = (keyRing = (PGPPublicKeyRing)var4.next()).getPublicKey(keyId)) == null);
        return publicKey;
    }

    private PGPPrivateKey findPrivateKey(InputStream keyIn, long keyID, char[] pass) throws Exception {
        PGPSecretKeyRingCollection pgpSec = new PGPSecretKeyRingCollection(PGPUtil.getDecoderStream((InputStream)keyIn), (KeyFingerPrintCalculator)new JcaPGPDigestCalculatorProviderBuilder().setProvider("BC").build());
        PGPSecretKey pgpSecKey = null;
        Iterator keyRingIterator = pgpSec.getKeyRings();
        while (pgpSecKey == null && keyRingIterator.hasNext()) {
            PGPSecretKeyRing keyRing = (PGPSecretKeyRing)keyRingIterator.next();
            pgpSecKey = keyRing.getSecretKey(keyID);
        }
        if (pgpSecKey == null) {
            return null;
        }
        PBESecretKeyDecryptor decryptor = new JcePBESecretKeyDecryptorBuilder(new JcaPGPDigestCalculatorProviderBuilder().setProvider("BC").build()).setProvider("BC").build(pass);
        try {
            return pgpSecKey.extractPrivateKey(decryptor);
        }
        catch (Exception e) {
            throw new Exception("Incorrect passphrase for the secret key.");
        }
    }

    private void decryptFile(InputStream in, OutputStream out, InputStream keyIn, char[] passwd) throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        in = PGPUtil.getDecoderStream((InputStream)in);
        PGPObjectFactory pgpF = new PGPObjectFactory(in, (KeyFingerPrintCalculator)new JcaPGPDigestCalculatorProviderBuilder().setProvider("BC").build());
        Object o = pgpF.nextObject();
        PGPEncryptedDataList enc = o instanceof PGPEncryptedDataList ? (PGPEncryptedDataList)o : (PGPEncryptedDataList)pgpF.nextObject();
        Iterator it = enc.getEncryptedDataObjects();
        PGPPrivateKey sKey = null;
        PGPPublicKeyEncryptedData pbe = null;
        while (sKey == null && it.hasNext()) {
            pbe = (PGPPublicKeyEncryptedData)it.next();
            sKey = this.findPrivateKey(keyIn, pbe.getKeyID(), passwd);
        }
        if (sKey == null) {
            throw new IllegalArgumentException("Secret key for message not found.");
        }
        PublicKeyDataDecryptorFactory b = new JcePublicKeyDataDecryptorFactoryBuilder().setProvider("BC").setContentProvider("BC").build(sKey);
        InputStream clear = pbe.getDataStream(b);
        PGPObjectFactory plainFact = new PGPObjectFactory(clear, (KeyFingerPrintCalculator)new JcaPGPDigestCalculatorProviderBuilder().setProvider("BC").build());
        Object message = plainFact.nextObject();
        if (message instanceof PGPCompressedData) {
            PGPCompressedData cData = (PGPCompressedData)message;
            PGPObjectFactory pgpFact = new PGPObjectFactory(cData.getDataStream(), (KeyFingerPrintCalculator)new JcaPGPDigestCalculatorProviderBuilder().setProvider("BC").build());
            message = pgpFact.nextObject();
        }
        if (message instanceof PGPLiteralData) {
            int ch;
            PGPLiteralData ld = (PGPLiteralData)message;
            InputStream unc = ld.getInputStream();
            while ((ch = unc.read()) >= 0) {
                out.write(ch);
            }
        } else {
            if (message instanceof PGPOnePassSignatureList) {
                throw new PGPException("Encrypted message contains a signed message - not literal data.");
            }
            throw new PGPException("Message is not a simple encrypted file - type unknown.");
        }
        if (pbe.isIntegrityProtected() && !pbe.verify()) {
            throw new PGPException("Message failed integrity check");
        }
    }

    private void encryptFile(OutputStream out, String fileName, PGPPublicKey encKey, boolean armor, boolean withIntegrityCheck) throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        if (armor) {
            out = new ArmoredOutputStream(out);
        }
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        PGPCompressedDataGenerator comData = new PGPCompressedDataGenerator(1);
        PGPUtil.writeFileToLiteralData((OutputStream)comData.open((OutputStream)bOut), (char)'b', (File)new File(fileName));
        comData.close();
        JcePGPDataEncryptorBuilder c = new JcePGPDataEncryptorBuilder(3).setWithIntegrityPacket(withIntegrityCheck).setSecureRandom(new SecureRandom()).setProvider("BC");
        PGPEncryptedDataGenerator cPk = new PGPEncryptedDataGenerator((PGPDataEncryptorBuilder)c);
        JcePublicKeyKeyEncryptionMethodGenerator d = new JcePublicKeyKeyEncryptionMethodGenerator(encKey).setProvider((Provider)new BouncyCastleProvider()).setSecureRandom(new SecureRandom());
        cPk.addMethod((PGPKeyEncryptionMethodGenerator)d);
        byte[] bytes = bOut.toByteArray();
        OutputStream cOut = cPk.open(out, (long)bytes.length);
        cOut.write(bytes);
        cOut.close();
        out.close();
    }

    private boolean vs(InputStream fileName, byte[] b, InputStream keyIn) throws Exception {
        int ch;
        PGPSignatureList p3;
        PGPObjectFactory pgpFact = new PGPObjectFactory(b, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
        Object o = pgpFact.nextObject();
        if (o instanceof PGPCompressedData) {
            PGPCompressedData c1 = (PGPCompressedData)o;
            pgpFact = new PGPObjectFactory(c1.getDataStream(), (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
            p3 = (PGPSignatureList)pgpFact.nextObject();
        } else {
            p3 = (PGPSignatureList)o;
        }
        BufferedInputStream dIn = new BufferedInputStream(fileName);
        PGPSignature sig = p3.get(0);
        PGPPublicKey key = this.findPublicKey(sig.getKeyID(), keyIn);
        sig.init((PGPContentVerifierBuilderProvider)new JcaPGPContentVerifierBuilderProvider().setProvider((Provider)new BouncyCastleProvider()), key);
        while ((ch = ((InputStream)dIn).read()) >= 0) {
            sig.update((byte)ch);
        }
        ((InputStream)dIn).close();
        return sig.verify();
    }

    private byte[] cs(String fileName, InputStream keyIn, char[] pass, boolean armor) throws Exception {
        int ch;
        PGPSecretKey pgpSecKey = this.findSecretKey(keyIn);
        PGPPrivateKey pgpPrivKey = pgpSecKey.extractPrivateKey(new JcePBESecretKeyDecryptorBuilder().setProvider((Provider)new BouncyCastleProvider()).build(pass));
        PGPSignatureGenerator sGen = new PGPSignatureGenerator((PGPContentSignerBuilder)new JcaPGPContentSignerBuilder(pgpSecKey.getPublicKey().getAlgorithm(), 2).setProvider((Provider)new BouncyCastleProvider()));
        sGen.init(0, pgpPrivKey);
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        ArmoredOutputStream aOut = new ArmoredOutputStream((OutputStream)byteOut);
        BCPGOutputStream bOut = new BCPGOutputStream((OutputStream)byteOut);
        BufferedInputStream fIn = new BufferedInputStream(new FileInputStream(fileName));
        while ((ch = ((InputStream)fIn).read()) >= 0) {
            sGen.update((byte)ch);
        }
        aOut.endClearText();
        ((InputStream)fIn).close();
        sGen.generate().encode((OutputStream)bOut);
        if (armor) {
            aOut.close();
        }
        return byteOut.toByteArray();
    }

    public static byte[] signatureCreate(String filePath, String privateKeyPath, String outFilePath, String passWord, boolean base64) {
        try {
            FileInputStream privKeyIn = new FileInputStream(privateKeyPath);
            FileOutputStream signatureOut = new FileOutputStream(outFilePath);
            byte[] sig = PgpUtil.getInstance().cs(filePath, privKeyIn, passWord.toCharArray(), true);
            if (base64) {
                sig = Base64.encode((byte[])sig);
            }
            signatureOut.write(sig);
            signatureOut.flush();
            signatureOut.close();
            privKeyIn.close();
            return sig;
        }
        catch (Exception e) {
            log.error(CkLogger.getTrace(e));
            return null;
        }
    }

    public static boolean signatureVerify(String filePath, String publicKeyPath, String signFilePath) {
        try {
            FileInputStream pubKeyIs = new FileInputStream(publicKeyPath);
            FileInputStream signFile = new FileInputStream(signFilePath);
            byte[] signFileBytes = new byte[signFile.available()];
            signFile.read(signFileBytes);
            boolean verifyResult = PgpUtil.getInstance().vs(new FileInputStream(filePath), signFileBytes, pubKeyIs);
            signFile.close();
            pubKeyIs.close();
            return verifyResult;
        }
        catch (Exception e) {
            log.error(CkLogger.getTrace(e));
            return false;
        }
    }

    public static boolean signatureVerify(InputStream filePath, InputStream publicKeyPath, InputStream signFilePath) {
        try {
            byte[] signFileBytes = new byte[signFilePath.available()];
            signFilePath.read(signFileBytes);
            boolean verifyResult = PgpUtil.getInstance().vs(filePath, signFileBytes, publicKeyPath);
            signFilePath.close();
            filePath.close();
            publicKeyPath.close();
            return verifyResult;
        }
        catch (Exception e) {
            log.error(CkLogger.getTrace(e));
            return false;
        }
    }

    private byte[] inputStreamToByteArray(InputStream is) throws Exception {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[1024];
        while ((nRead = is.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        buffer.flush();
        return buffer.toByteArray();
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
        INSTANCE = null;
    }
}

