/*
 * Decompiled with CFR 0.152.
 */
package com.gomyck.util.elastic;

import com.gomyck.util.ObjectJudge;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.CreateIndexResponse;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ES7Client<P, R> {
    private static final Logger log = LoggerFactory.getLogger(ES7Client.class);
    private static volatile RestHighLevelClient client;
    private Consumer<String> consumer;
    private Object operatorObj;
    private Consumer<Object> resultConsumer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ES7Client<?, ?> init(ESNodeInfo ... esNodeInfos) {
        if (client != null) return new ES7Client();
        Class<ES7Client> clazz = ES7Client.class;
        synchronized (ES7Client.class) {
            if (client != null) return new ES7Client();
            HttpHost[] httpHosts = new HttpHost[esNodeInfos.length];
            for (int i = 0; i < esNodeInfos.length; ++i) {
                ESNodeInfo esNodeInfo = esNodeInfos[i];
                httpHosts[i] = new HttpHost(esNodeInfo.getHost(), esNodeInfo.getPort(), esNodeInfo.getScheme());
            }
            client = new RestHighLevelClient(RestClient.builder((HttpHost[])httpHosts).setHttpClientConfigCallback(httpClientBuilder -> ES7Client.getHttpAsyncClientBuilder(httpClientBuilder, esNodeInfos, null)));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return new ES7Client();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ES7Client<?, ?> init(String userName, String password, ESNodeInfo ... esNodeInfos) {
        if (client != null) return new ES7Client();
        Class<ES7Client> clazz = ES7Client.class;
        synchronized (ES7Client.class) {
            if (client != null) return new ES7Client();
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(userName, password));
            HttpHost[] httpHosts = new HttpHost[esNodeInfos.length];
            for (int i = 0; i < esNodeInfos.length; ++i) {
                ESNodeInfo esNodeInfo = esNodeInfos[i];
                httpHosts[i] = new HttpHost(esNodeInfo.getHost(), esNodeInfo.getPort(), esNodeInfo.getScheme());
            }
            client = new RestHighLevelClient(RestClient.builder((HttpHost[])httpHosts).setHttpClientConfigCallback(arg_0 -> ES7Client.lambda$init$1(esNodeInfos, (CredentialsProvider)credentialsProvider, arg_0)));
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return new ES7Client();
        }
    }

    private static HttpAsyncClientBuilder getHttpAsyncClientBuilder(HttpAsyncClientBuilder httpClientBuilder, ESNodeInfo[] esNodeInfos, CredentialsProvider credentialsProvider) {
        if ("https".equalsIgnoreCase(esNodeInfos[0].getScheme())) {
            try {
                SSLContext sslContext = SSLContext.getInstance("TLS");
                TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                    @Override
                    public void checkClientTrusted(X509Certificate[] chain, String authType) {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] chain, String authType) {
                    }

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return new X509Certificate[0];
                    }
                }};
                sslContext.init(null, trustAllCerts, new SecureRandom());
                httpClientBuilder.setSSLHostnameVerifier((s, sslSession) -> true);
                httpClientBuilder.setSSLContext(sslContext);
                if (Objects.nonNull(credentialsProvider)) {
                    httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
                }
            }
            catch (KeyManagementException | NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }
        httpClientBuilder.setMaxConnTotal(999);
        httpClientBuilder.setMaxConnPerRoute(100);
        return httpClientBuilder;
    }

    private void doConsumer(String stepName) {
        if (this.consumer != null) {
            this.consumer.accept(stepName);
            this.consumer = null;
        }
    }

    private void callBackResult(Object response) {
        if (this.resultConsumer != null) {
            this.resultConsumer.accept(response);
            this.resultConsumer = null;
        }
    }

    public void execute() {
        this.doConsumer("execute");
    }

    public void close() {
        this.doConsumer("close");
        try {
            client.close();
            client = null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public P getOperatorObj() {
        return (P)this.operatorObj;
    }

    public void resultCallBack(Consumer<R> resultConsumer) {
        this.resultConsumer = resultConsumer;
    }

    public ES7Client<CreateIndexRequest, CreateIndexResponse> createIndex(String indexName) {
        this.doConsumer("createIndex");
        CreateIndexRequest request = new CreateIndexRequest(indexName);
        request.settings(Settings.builder().put("index.number_of_shards", 3).put("index.number_of_replicas", 2));
        HashMap<String, String> message = new HashMap<String, String>();
        message.put("type", "text");
        HashMap<String, HashMap<String, String>> properties = new HashMap<String, HashMap<String, String>>();
        properties.put("message", message);
        HashMap<String, HashMap<String, HashMap<String, String>>> mapping = new HashMap<String, HashMap<String, HashMap<String, String>>>();
        mapping.put("properties", properties);
        request.mapping(mapping);
        this.operatorObj = request;
        this.consumer = stepName -> {
            try {
                log.debug("createIndex: {}, next step is: {}", (Object)indexName, stepName);
                CreateIndexResponse response = client.indices().create(request, RequestOptions.DEFAULT);
                this.callBackResult(response);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
        return this;
    }

    public ES7Client<IndexRequest, IndexResponse> insertDocument(String indexName, String id, Object doc) {
        this.doConsumer("insertDocument");
        IndexRequest request = new IndexRequest(indexName);
        if (ObjectJudge.notNull((Object)id)) {
            request.id(id);
        }
        if (doc instanceof String) {
            request.source((String)doc, XContentType.JSON);
        } else if (doc instanceof Map) {
            request.source((Map)doc, XContentType.JSON);
        }
        this.operatorObj = request;
        this.consumer = stepName -> {
            try {
                log.debug("insertDocument, index: {}, id: {}, doc: {}, next step is: {}", new Object[]{indexName, id, doc, stepName});
                IndexResponse response = client.index(request, RequestOptions.DEFAULT);
                this.callBackResult(response);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
        return this;
    }

    public ES7Client<GetRequest, GetResponse> searchDocumentById(String indexName, String id) {
        this.doConsumer("searchDocumentById");
        GetRequest request = new GetRequest(indexName, id);
        this.operatorObj = request;
        this.consumer = stepName -> {
            try {
                log.debug("searchDocumentById, index: {}, id: {}, next step is: {}", new Object[]{indexName, id, stepName});
                GetResponse response = client.get(request, RequestOptions.DEFAULT);
                this.callBackResult(response);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
        return this;
    }

    public ES7Client<SearchRequest, SearchResponse> searchDocumentByQuery(SearchSourceBuilder searchSourceBuilder, String ... indexName) {
        this.doConsumer("searchDocumentByQuery");
        searchSourceBuilder.timeout(new TimeValue(60L, TimeUnit.SECONDS));
        SearchRequest searchRequest = new SearchRequest(indexName);
        searchRequest.source(searchSourceBuilder);
        this.operatorObj = searchRequest;
        this.consumer = stepName -> {
            try {
                log.debug("searchDocumentByQuery, index: {}, queryBuilder: {}, next step is: {}", new Object[]{indexName, searchSourceBuilder, stepName});
                SearchResponse response = client.search(searchRequest, RequestOptions.DEFAULT);
                this.callBackResult(response);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
        return this;
    }

    public ES7Client<DeleteRequest, DeleteResponse> deleteDocumentById(String indexName, String id) {
        this.doConsumer("deleteDocumentById");
        DeleteRequest request = new DeleteRequest(indexName, id);
        this.operatorObj = request;
        this.consumer = stepName -> {
            try {
                log.debug("deleteDocumentById, index: {}, id: {}, next step is: {}", new Object[]{indexName, id, stepName});
                DeleteResponse response = client.delete(request, RequestOptions.DEFAULT);
                this.callBackResult(response);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
        return this;
    }

    public ES7Client<DeleteIndexRequest, AcknowledgedResponse> deleteIndex(String indexName) {
        this.doConsumer("deleteIndex");
        DeleteIndexRequest request = new DeleteIndexRequest(indexName);
        this.operatorObj = request;
        this.consumer = stepName -> {
            try {
                log.debug("deleteIndex, index: {}, next step is: {}", (Object)indexName, stepName);
                AcknowledgedResponse response = client.indices().delete(request, RequestOptions.DEFAULT);
                this.callBackResult(response);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
        return this;
    }

    public static RestHighLevelClient getClient() {
        return client;
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$init$1(ESNodeInfo[] esNodeInfos, CredentialsProvider credentialsProvider, HttpAsyncClientBuilder httpClientBuilder) {
        return ES7Client.getHttpAsyncClientBuilder(httpClientBuilder, esNodeInfos, credentialsProvider);
    }

    public static class ESNodeInfo {
        private String scheme;
        private String host;
        private int port;

        ESNodeInfo(String scheme, String host, int port) {
            this.scheme = scheme;
            this.host = host;
            this.port = port;
        }

        public static ESNodeInfoBuilder builder() {
            return new ESNodeInfoBuilder();
        }

        public String getScheme() {
            return this.scheme;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public void setScheme(String scheme) {
            this.scheme = scheme;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ESNodeInfo)) {
                return false;
            }
            ESNodeInfo other = (ESNodeInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getPort() != other.getPort()) {
                return false;
            }
            String this$scheme = this.getScheme();
            String other$scheme = other.getScheme();
            if (this$scheme == null ? other$scheme != null : !this$scheme.equals(other$scheme)) {
                return false;
            }
            String this$host = this.getHost();
            String other$host = other.getHost();
            return !(this$host == null ? other$host != null : !this$host.equals(other$host));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ESNodeInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getPort();
            String $scheme = this.getScheme();
            result = result * 59 + ($scheme == null ? 43 : $scheme.hashCode());
            String $host = this.getHost();
            result = result * 59 + ($host == null ? 43 : $host.hashCode());
            return result;
        }

        public String toString() {
            return "ES7Client.ESNodeInfo(scheme=" + this.getScheme() + ", host=" + this.getHost() + ", port=" + this.getPort() + ")";
        }

        public static class ESNodeInfoBuilder {
            private String scheme;
            private String host;
            private int port;

            ESNodeInfoBuilder() {
            }

            public ESNodeInfoBuilder scheme(String scheme) {
                this.scheme = scheme;
                return this;
            }

            public ESNodeInfoBuilder host(String host) {
                this.host = host;
                return this;
            }

            public ESNodeInfoBuilder port(int port) {
                this.port = port;
                return this;
            }

            public ESNodeInfo build() {
                return new ESNodeInfo(this.scheme, this.host, this.port);
            }

            public String toString() {
                return "ES7Client.ESNodeInfo.ESNodeInfoBuilder(scheme=" + this.scheme + ", host=" + this.host + ", port=" + this.port + ")";
            }
        }
    }
}

