/*
 * Decompiled with CFR 0.152.
 */
package com.gomyck.util.encrypt;

import com.gomyck.util.ObjectJudge;
import com.gomyck.util.digest.MD5;
import com.gomyck.util.digest.SHA256Util;
import com.gomyck.util.digest.Sha1;
import com.gomyck.util.encrypt.RSAUtil;
import com.gomyck.util.log.logger.CkLogger;
import java.io.File;
import java.io.FileInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class APKVerify {
    private static final Logger log = LoggerFactory.getLogger(APKVerify.class);
    public static final String PRIVATE_KEY = "";
    public static final String PUBLIC_KEY = "";

    public static boolean verifyAuthorizationCode(String code, String pubKey, String equalsCode) {
        try {
            byte[] decrypt = RSAUtil.decrypt(RSAUtil.loadPublicKeyByStr(pubKey), RSAUtil.base64Decode(code));
            return SHA256Util.sha256Hex(equalsCode).equals(new String(decrypt));
        }
        catch (Exception e) {
            log.error(CkLogger.getTrace(e));
            return false;
        }
    }

    public static String initAuthorizationCode(String in) {
        try {
            String server_hex = SHA256Util.sha256Hex(in);
            byte[] encrypt = RSAUtil.encrypt(RSAUtil.loadPrivateKeyByStr(""), server_hex.getBytes());
            return RSAUtil.base64Encode(encrypt);
        }
        catch (Exception e) {
            log.error(CkLogger.getTrace(e));
            return "";
        }
    }

    public static boolean verifyRequestParams(String params, String secretId, String signValue) {
        if (ObjectJudge.hasNull(secretId, signValue)) {
            return false;
        }
        StringBuffer sb = new StringBuffer(params);
        sb.append(secretId);
        String md5ofStr = MD5.init().createDigest(sb.toString()).toUpperCase();
        String _signValue = Sha1.getSha1(md5ofStr + secretId).toUpperCase();
        return _signValue.equals(signValue);
    }

    public static byte[] initOAuthInfo(String filePath) {
        try {
            File file = new File(filePath);
            return APKVerify.initOAuthInfo(file);
        }
        catch (Exception e) {
            log.error(CkLogger.getTrace(e));
            log.error("\u751f\u6210\u6388\u6743\u6587\u4ef6\u5b57\u8282\u6570\u7ec4\u5931\u8d25: " + e.toString());
            return null;
        }
    }

    public static byte[] initOAuthInfo(File apkFile) {
        try {
            FileInputStream fis = new FileInputStream(apkFile);
            byte[] b = new byte[fis.available()];
            fis.read(b);
            fis.close();
            return APKVerify.initOAuthInfo(b);
        }
        catch (Exception e) {
            log.error(CkLogger.getTrace(e));
            log.error("\u751f\u6210\u6388\u6743\u6587\u4ef6\u5b57\u8282\u6570\u7ec4\u5931\u8d25: " + e.toString());
            return null;
        }
    }

    public static byte[] initOAuthInfo(byte[] apkBytes) {
        try {
            String server_hex = SHA256Util.sha256Hex(apkBytes);
            return RSAUtil.encrypt(RSAUtil.loadPrivateKeyByStr(""), server_hex.getBytes());
        }
        catch (Exception e) {
            log.error(CkLogger.getTrace(e));
            log.error("\u751f\u6210\u6388\u6743\u6587\u4ef6\u5b57\u8282\u6570\u7ec4\u5931\u8d25: " + e.toString());
            return null;
        }
    }

    public static boolean verifyApkByOAuthInfo(byte[] bs, String filePath) {
        try {
            File file = new File(filePath);
            return APKVerify.verifyApkByOAuthInfo(bs, file);
        }
        catch (Exception e) {
            log.error(CkLogger.getTrace(e));
            log.error("\u9a8c\u8bc1APK\u5931\u8d25: " + e);
            return false;
        }
    }

    public static boolean verifyApkByOAuthInfo(byte[] bs, File apkFile) {
        try {
            FileInputStream fis = new FileInputStream(apkFile);
            byte[] b = new byte[fis.available()];
            fis.read(b);
            fis.close();
            return APKVerify.verifyApkByOAuthInfo(bs, b);
        }
        catch (Exception e) {
            log.error(CkLogger.getTrace(e));
            log.error("\u9a8c\u8bc1APK\u5931\u8d25: " + e.toString());
            return false;
        }
    }

    public static boolean verifyApkByOAuthInfo(byte[] bs, byte[] apkBytes) {
        try {
            byte[] decrypt = RSAUtil.decrypt(RSAUtil.loadPublicKeyByStr(""), bs);
            String client_hex = new String(decrypt);
            String package_hex = SHA256Util.sha256Hex(apkBytes);
            return client_hex.equals(package_hex);
        }
        catch (Exception e) {
            log.error(CkLogger.getTrace(e));
            log.error("\u9a8c\u8bc1APK\u5931\u8d25: " + e.toString());
            return false;
        }
    }
}

