/*
 * Decompiled with CFR 0.152.
 */
package com.gomyck.util.encrypt;

import com.gomyck.util.encrypt.AlgorithmEnum;
import java.security.Key;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class CipherUtil {
    public static final String SPLIT_STR = "#ck#";
    public static final Base64.Decoder decoder = Base64.getUrlDecoder();
    public static final Base64.Encoder encoder = Base64.getUrlEncoder();

    public static String encrypt(AlgorithmEnum algorithm, String pwd, String param) {
        try {
            Cipher encipher = Cipher.getInstance(algorithm.getTransformation());
            encipher.init(1, new SecretKeySpec(pwd.getBytes(), algorithm.getAlgorithm()));
            byte[] _data = param.getBytes();
            int blockSize = 64;
            int blocksNum = (int)Math.ceil(1.0 * (double)_data.length / (double)blockSize);
            for (int i = 0; i < blocksNum; ++i) {
                _data = i < blocksNum - 1 ? encipher.doFinal(_data, i * blockSize, blockSize) : encipher.doFinal(_data, i * blockSize, _data.length - i * blockSize);
            }
            String iv = "none";
            if (encipher.getIV() != null) {
                iv = encoder.encodeToString(encipher.getIV());
            }
            return iv.concat(SPLIT_STR).concat(encoder.encodeToString(_data));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String decrypt(AlgorithmEnum algorithm, String pwd, String param) {
        if (!param.contains(SPLIT_STR)) {
            return "error param";
        }
        try {
            String[] params = param.split(SPLIT_STR);
            Cipher encipher = Cipher.getInstance(algorithm.getTransformation());
            if ("none".equals(params[0])) {
                encipher.init(2, new SecretKeySpec(pwd.getBytes(), algorithm.getAlgorithm()));
            } else {
                encipher.init(2, (Key)new SecretKeySpec(pwd.getBytes(), algorithm.getAlgorithm()), new IvParameterSpec(decoder.decode(params[0])));
            }
            byte[] _data = decoder.decode(params[1].getBytes());
            int blockSize = 64;
            int blocksNum = (int)Math.ceil(1.0 * (double)_data.length / (double)blockSize);
            for (int i = 0; i < blocksNum; ++i) {
                _data = i < blocksNum - 1 ? encipher.doFinal(_data, i * blockSize, blockSize) : encipher.doFinal(_data, i * blockSize, _data.length - i * blockSize);
            }
            return new String(_data);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) {
        String pwd = "xxxxxxxx";
        String param = "gomyck01";
        System.out.println(CipherUtil.encrypt(AlgorithmEnum.DES_CBC_PKCS5PADDING, pwd, param));
        System.out.println(CipherUtil.decrypt(AlgorithmEnum.DES_CBC_PKCS5PADDING, pwd, CipherUtil.encrypt(AlgorithmEnum.DES_CBC_PKCS5PADDING, pwd, param)));
    }
}

