/*
 * Decompiled with CFR 0.152.
 */
package com.gomyck.util.encrypt;

import java.io.FileOutputStream;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.Date;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.x509.X509V3CertificateGenerator;

public class PfxCreate {
    public static void main(String[] args) throws Exception {
        String issuer;
        String certPath = "/Users/haoyang/Desktop/tempDir/authKey.pfx";
        String alias = "authKey";
        String password = "";
        KeyStore store = KeyStore.getInstance("PKCS12");
        store.load(null, null);
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA");
        kpg.initialize(2048);
        KeyPair keyPair = kpg.generateKeyPair();
        String subject = issuer = "C=CN,ST=HERB,L=HERB,O=SICCA,OU=SC,CN=SICCA";
        X509V3CertificateGenerator certGen = new X509V3CertificateGenerator();
        certGen.setSerialNumber(BigInteger.valueOf(System.currentTimeMillis()));
        certGen.setIssuerDN(new X500Principal(issuer));
        certGen.setNotBefore(new Date(System.currentTimeMillis() - 50000L));
        Calendar c = Calendar.getInstance();
        c.add(1, 10);
        certGen.setNotAfter(c.getTime());
        certGen.setSubjectDN(new X500Principal(subject));
        certGen.setPublicKey(keyPair.getPublic());
        certGen.setSignatureAlgorithm("SHA256WithRSAEncryption");
        X509Certificate cert = certGen.generateX509Certificate(keyPair.getPrivate());
        store.setKeyEntry(alias, keyPair.getPrivate(), password.toCharArray(), new Certificate[]{cert});
        FileOutputStream fout = new FileOutputStream(certPath);
        store.store(fout, password.toCharArray());
        fout.close();
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

