/*
 * Decompiled with CFR 0.152.
 */
package com.gomyck.util.jqgrid;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.gomyck.util.CkParam;
import com.gomyck.util.ObjectJudge;
import com.gomyck.util.jqgrid.Filters;
import com.gomyck.util.jqgrid.Rules;
import com.gomyck.util.log.logger.CkLogger;
import com.gomyck.util.serialize.CKJSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JqWrapper {
    private static final Logger log = LoggerFactory.getLogger(JqWrapper.class);

    public static Wrapper init(String filters, QueryWrapper wrapper) {
        try {
            if (ObjectJudge.isNull((Object)filters)) {
                return wrapper;
            }
            Filters f = CKJSON.getInstance().parseObject(filters, Filters.class);
            if (f == null) {
                return wrapper;
            }
            if (ObjectJudge.isNull((Object)f.getGroupOp())) {
                return wrapper;
            }
            if (f.getRules() == null) {
                return wrapper;
            }
            wrapper.and(e -> {});
            boolean firstNoAddOp = false;
            for (Rules r : f.getRules()) {
                if (firstNoAddOp) {
                    if ("AND".equals(f.getGroupOp())) {
                        wrapper.and(e -> {});
                    }
                    if ("OR".equals(f.getGroupOp())) {
                        wrapper.or();
                    }
                } else {
                    firstNoAddOp = true;
                }
                String condition = CkParam.humpToUnderline(r.getField());
                if ("eq".equals(r.getOp())) {
                    wrapper.eq((Object)condition, (Object)r.getData());
                    continue;
                }
                if ("ne".equals(r.getOp())) {
                    wrapper.ne((Object)condition, (Object)r.getData());
                    continue;
                }
                if ("cn".equals(r.getOp())) {
                    wrapper.like((Object)condition, (Object)r.getData());
                    continue;
                }
                if ("nc".equals(r.getOp())) {
                    wrapper.notLike((Object)condition, (Object)r.getData());
                    continue;
                }
                if ("nu".equals(r.getOp())) {
                    wrapper.isNull((Object)condition);
                    continue;
                }
                if ("nn".equals(r.getOp())) {
                    wrapper.isNotNull((Object)condition);
                    continue;
                }
                if ("in".equals(r.getOp())) {
                    wrapper.in((Object)condition, new Object[]{r.getData()});
                    continue;
                }
                if ("ni".equals(r.getOp())) {
                    wrapper.notIn((Object)condition, new Object[]{r.getData()});
                    continue;
                }
                if ("bw".equals(r.getOp())) {
                    wrapper.like((Object)condition, (Object)(r.getData() + "_"));
                    continue;
                }
                if ("bn".equals(r.getOp())) {
                    wrapper.notLike((Object)condition, (Object)(r.getData() + "_"));
                    continue;
                }
                if ("ew".equals(r.getOp())) {
                    wrapper.like((Object)condition, (Object)("_" + r.getData()));
                    continue;
                }
                if ("en".equals(r.getOp())) {
                    wrapper.notLike((Object)condition, (Object)("_" + r.getData()));
                    continue;
                }
                wrapper.eq((Object)condition, (Object)r.getData());
            }
        }
        catch (Exception e2) {
            log.error(CkLogger.getTrace(e2));
        }
        return wrapper;
    }
}

