/*
 * Decompiled with CFR 0.152.
 */
package com.gomyck.util.minio;

import com.gomyck.util.AutoConfig;
import com.gomyck.util.minio.MinioConfigurationProperties;
import com.gomyck.util.minio.MinioException;
import com.gomyck.util.minio.MinioService;
import io.minio.BucketExistsArgs;
import io.minio.MakeBucketArgs;
import io.minio.MinioClient;
import java.net.InetSocketAddress;
import java.net.Proxy;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@ConditionalOnClass(value={MinioClient.class})
@Import(value={MinioService.class})
@EnableConfigurationProperties(value={MinioConfigurationProperties.class})
public class MinioAutoConfig
implements AutoConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(MinioAutoConfig.class);
    @Autowired
    private MinioConfigurationProperties minioConfigurationProperties;

    @Bean
    public MinioClient minioClient() throws Exception {
        MinioClient minioClient;
        block6: {
            minioClient = !this.configuredProxy() ? MinioClient.builder().endpoint(this.minioConfigurationProperties.getUrl()).credentials(this.minioConfigurationProperties.getAccessKey(), this.minioConfigurationProperties.getSecretKey()).build() : MinioClient.builder().endpoint(this.minioConfigurationProperties.getUrl()).credentials(this.minioConfigurationProperties.getAccessKey(), this.minioConfigurationProperties.getSecretKey()).httpClient(this.client()).build();
            minioClient.setTimeout(this.minioConfigurationProperties.getConnectTimeout().toMillis(), this.minioConfigurationProperties.getWriteTimeout().toMillis(), this.minioConfigurationProperties.getReadTimeout().toMillis());
            if (this.minioConfigurationProperties.isCheckBucket()) {
                try {
                    LOGGER.debug("Checking if bucket {} exists", (Object)this.minioConfigurationProperties.getBucket());
                    BucketExistsArgs existsArgs = (BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(this.minioConfigurationProperties.getBucket())).build();
                    boolean b = minioClient.bucketExists(existsArgs);
                    if (b) break block6;
                    if (this.minioConfigurationProperties.isCreateBucket()) {
                        try {
                            MakeBucketArgs makeBucketArgs = (MakeBucketArgs)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(this.minioConfigurationProperties.getBucket())).build();
                            minioClient.makeBucket(makeBucketArgs);
                            break block6;
                        }
                        catch (Exception e) {
                            throw new MinioException("Cannot create bucket", e);
                        }
                    }
                    throw new IllegalStateException("Bucket does not exist: " + this.minioConfigurationProperties.getBucket());
                }
                catch (Exception e) {
                    LOGGER.error("Error while checking bucket", (Throwable)e);
                    throw e;
                }
            }
        }
        LOGGER.info("Minio client initialized");
        return minioClient;
    }

    private boolean configuredProxy() {
        String httpHost = System.getProperty("http.proxyHost");
        String httpPort = System.getProperty("http.proxyPort");
        return httpHost != null && httpPort != null;
    }

    private OkHttpClient client() {
        String httpHost = System.getProperty("http.proxyHost");
        String httpPort = System.getProperty("http.proxyPort");
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        if (httpHost != null) {
            builder.proxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(httpHost, Integer.parseInt(httpPort))));
        }
        return builder.build();
    }
}

