/*
 * Decompiled with CFR 0.152.
 */
package com.gomyck.util.minio;

import com.gomyck.util.DataFilter;
import com.gomyck.util.minio.MinioBus;
import com.gomyck.util.minio.MinioConfigurationProperties;
import com.gomyck.util.minio.MinioException;
import com.gomyck.util.minio.MinioFetchException;
import io.minio.DownloadObjectArgs;
import io.minio.GetObjectArgs;
import io.minio.ListObjectsArgs;
import io.minio.MinioClient;
import io.minio.PutObjectArgs;
import io.minio.RemoveObjectArgs;
import io.minio.Result;
import io.minio.StatObjectArgs;
import io.minio.StatObjectResponse;
import io.minio.UploadObjectArgs;
import io.minio.messages.Item;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.springframework.beans.factory.annotation.Autowired;

public class MinioService {
    private final MinioClient minioClient;
    private final MinioConfigurationProperties configurationProperties;

    @Autowired
    public MinioService(MinioClient minioClient, MinioConfigurationProperties configurationProperties) {
        this.minioClient = minioClient;
        this.configurationProperties = configurationProperties;
    }

    public List<Item> list() {
        ListObjectsArgs args = (ListObjectsArgs)((ListObjectsArgs.Builder)ListObjectsArgs.builder().bucket(DataFilter.getFirstNotNull(MinioBus.getBucket(), this.configurationProperties.getBucket()).toString())).prefix("").recursive(false).build();
        Iterable myObjects = this.minioClient.listObjects(args);
        return this.getItems(myObjects);
    }

    public List<Item> fullList() {
        ListObjectsArgs args = (ListObjectsArgs)((ListObjectsArgs.Builder)ListObjectsArgs.builder().bucket(DataFilter.getFirstNotNull(MinioBus.getBucket(), this.configurationProperties.getBucket()).toString())).build();
        Iterable myObjects = this.minioClient.listObjects(args);
        return this.getItems(myObjects);
    }

    public List<Item> list(Path path) {
        ListObjectsArgs args = (ListObjectsArgs)((ListObjectsArgs.Builder)ListObjectsArgs.builder().bucket(DataFilter.getFirstNotNull(MinioBus.getBucket(), this.configurationProperties.getBucket()).toString())).prefix(path.toString()).recursive(false).build();
        Iterable myObjects = this.minioClient.listObjects(args);
        return this.getItems(myObjects);
    }

    public List<Item> getFullList(Path path) {
        ListObjectsArgs args = (ListObjectsArgs)((ListObjectsArgs.Builder)ListObjectsArgs.builder().bucket(DataFilter.getFirstNotNull(MinioBus.getBucket(), this.configurationProperties.getBucket()).toString())).prefix(path.toString()).build();
        Iterable myObjects = this.minioClient.listObjects(args);
        return this.getItems(myObjects);
    }

    private List<Item> getItems(Iterable<Result<Item>> myObjects) {
        return StreamSupport.stream(myObjects.spliterator(), true).map(itemResult -> {
            try {
                return (Item)itemResult.get();
            }
            catch (Exception e) {
                throw new MinioFetchException("Error while parsing list of objects", e);
            }
        }).collect(Collectors.toList());
    }

    public InputStream get(Path path) throws MinioException {
        try {
            GetObjectArgs args = (GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(DataFilter.getFirstNotNull(MinioBus.getBucket(), this.configurationProperties.getBucket()).toString())).object(path.toString())).build();
            return this.minioClient.getObject(args);
        }
        catch (Exception e) {
            throw new MinioException("Error while fetching files in Minio", e);
        }
    }

    public StatObjectResponse getMetadata(Path path) throws MinioException {
        try {
            StatObjectArgs args = (StatObjectArgs)((StatObjectArgs.Builder)((StatObjectArgs.Builder)StatObjectArgs.builder().bucket(DataFilter.getFirstNotNull(MinioBus.getBucket(), this.configurationProperties.getBucket()).toString())).object(path.toString())).build();
            return this.minioClient.statObject(args);
        }
        catch (Exception e) {
            throw new MinioException("Error while fetching files in Minio", e);
        }
    }

    public Map<Path, StatObjectResponse> getMetadata(Iterable<Path> paths) {
        return StreamSupport.stream(paths.spliterator(), false).map(path -> {
            try {
                StatObjectArgs args = (StatObjectArgs)((StatObjectArgs.Builder)((StatObjectArgs.Builder)StatObjectArgs.builder().bucket(DataFilter.getFirstNotNull(MinioBus.getBucket(), this.configurationProperties.getBucket()).toString())).object(path.toString())).build();
                return new AbstractMap.SimpleEntry<Path, StatObjectResponse>((Path)path, this.minioClient.statObject(args));
            }
            catch (Exception e) {
                throw new MinioFetchException("Error while parsing list of objects", e);
            }
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public void getAndSave(Path source, String fileName) throws MinioException {
        try {
            DownloadObjectArgs args = (DownloadObjectArgs)((DownloadObjectArgs.Builder)((DownloadObjectArgs.Builder)DownloadObjectArgs.builder().bucket(DataFilter.getFirstNotNull(MinioBus.getBucket(), this.configurationProperties.getBucket()).toString())).object(source.toString())).filename(fileName).build();
            this.minioClient.downloadObject(args);
        }
        catch (Exception e) {
            throw new MinioException("Error while fetching files in Minio", e);
        }
    }

    public void upload(Path source, InputStream file, Map<String, String> headers) throws MinioException {
        try {
            PutObjectArgs args = (PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(DataFilter.getFirstNotNull(MinioBus.getBucket(), this.configurationProperties.getBucket()).toString())).object(source.toString())).stream(file, (long)file.available(), -1L).headers(headers)).build();
            this.minioClient.putObject(args);
        }
        catch (Exception e) {
            throw new MinioException("Error while fetching files in Minio", e);
        }
    }

    public void upload(Path source, InputStream file) throws MinioException {
        try {
            PutObjectArgs args = (PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(DataFilter.getFirstNotNull(MinioBus.getBucket(), this.configurationProperties.getBucket()).toString())).object(source.toString())).stream(file, (long)file.available(), -1L).build();
            this.minioClient.putObject(args);
        }
        catch (Exception e) {
            throw new MinioException("Error while fetching files in Minio", e);
        }
    }

    public void upload(Path source, InputStream file, String contentType, Map<String, String> headers) throws MinioException {
        try {
            PutObjectArgs args = (PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(DataFilter.getFirstNotNull(MinioBus.getBucket(), this.configurationProperties.getBucket()).toString())).object(source.toString())).stream(file, (long)file.available(), -1L).headers(headers)).contentType(contentType).build();
            this.minioClient.putObject(args);
        }
        catch (Exception e) {
            throw new MinioException("Error while fetching files in Minio", e);
        }
    }

    public void upload(Path source, InputStream file, String contentType) throws MinioException {
        try {
            PutObjectArgs args = (PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(DataFilter.getFirstNotNull(MinioBus.getBucket(), this.configurationProperties.getBucket()).toString())).object(source.toString())).stream(file, (long)file.available(), -1L).contentType(contentType).build();
            this.minioClient.putObject(args);
        }
        catch (Exception e) {
            throw new MinioException("Error while fetching files in Minio", e);
        }
    }

    public void upload(Path source, File file) throws MinioException {
        try {
            UploadObjectArgs args = (UploadObjectArgs)((UploadObjectArgs.Builder)((UploadObjectArgs.Builder)UploadObjectArgs.builder().bucket(DataFilter.getFirstNotNull(MinioBus.getBucket(), this.configurationProperties.getBucket()).toString())).object(source.toString())).filename(file.getAbsolutePath()).build();
            this.minioClient.uploadObject(args);
        }
        catch (Exception e) {
            throw new MinioException("Error while fetching files in Minio", e);
        }
    }

    public void remove(Path source) throws MinioException {
        try {
            RemoveObjectArgs args = (RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(DataFilter.getFirstNotNull(MinioBus.getBucket(), this.configurationProperties.getBucket()).toString())).object(source.toString())).build();
            this.minioClient.removeObject(args);
        }
        catch (Exception e) {
            throw new MinioException("Error while fetching files in Minio", e);
        }
    }
}

