/*
 * Decompiled with CFR 0.152.
 */
package com.gomyck.util.serialize;

import com.gomyck.util.serialize.JSONAdapter;
import com.gomyck.util.serialize.JSONType;
import com.gomyck.util.serialize.strategy.InitStrategy;
import java.util.List;
import java.util.Map;

public class CKJSON
implements JSONAdapter {
    private static volatile CKJSON ckjson;
    private final JSONType jsonType;
    private final JSONAdapter adapter;
    private JSONAdapter pretty_adapter;
    private final InitStrategy initStrategy;

    public CKJSON(InitStrategy initStrategy) {
        try {
            Class.forName(initStrategy.getClassName(), false, CKJSON.class.getClassLoader());
            JSONType jsonType = initStrategy.getJsonType();
            JSONAdapter adapter = initStrategy.getInitClazz().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.jsonType = jsonType;
            this.adapter = adapter;
            this.initStrategy = initStrategy;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CKJSON getInstance() {
        if (ckjson != null) return ckjson;
        Class<CKJSON> clazz = CKJSON.class;
        synchronized (CKJSON.class) {
            if (ckjson != null) return ckjson;
            for (InitStrategy strategy : InitStrategy.getAll()) {
                try {
                    ckjson = new CKJSON(strategy);
                    break;
                }
                catch (Exception exception) {
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return ckjson;
        }
    }

    public static CKJSON getInstance(InitStrategy strategy) {
        return new CKJSON(strategy);
    }

    @Override
    public Object toJson(Object json) {
        return this.adapter.toJson(json);
    }

    @Override
    public Object toJsonMap(Object json) {
        return this.adapter.toJsonMap(json);
    }

    @Override
    public <T> T parseObject(String jsonStr, Class<T> type) {
        return this.adapter.parseObject(jsonStr, type);
    }

    @Override
    public String toJsonString(Object obj) {
        return this.adapter.toJsonString(obj);
    }

    @Override
    public <T> List<T> parseArray(String text, Class<T> type) {
        return this.adapter.parseArray(text, type);
    }

    @Override
    public boolean isValid(String text) {
        return this.adapter.isValid(text);
    }

    @Override
    public Map<String, Object> parseMap(String text) {
        return this.adapter.parseMap(text);
    }

    @Override
    public List<Map<String, Object>> parseListMap(String text) {
        return this.adapter.parseListMap(text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JSONAdapter prettyPrint() {
        try {
            if (this.pretty_adapter == null) {
                CKJSON cKJSON = this;
                synchronized (cKJSON) {
                    this.pretty_adapter = this.initStrategy.getInitClazz().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    this.pretty_adapter.prettyPrint();
                }
            }
            return this.pretty_adapter;
        }
        catch (Exception exception) {
            throw new RuntimeException("no JSONAdapter in used ...");
        }
    }

    public JSONType getJsonType() {
        return this.jsonType;
    }

    public JSONAdapter getAdapter() {
        return this.adapter;
    }

    public JSONAdapter getPretty_adapter() {
        return this.pretty_adapter;
    }
}

