/*
 * Decompiled with CFR 0.152.
 */
package com.gomyck.util.servlet;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class RequestReader {
    public static Map<String, String> getAllQueryParam(String queryString) {
        String[] paramArr = queryString.split("&");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        Arrays.stream(paramArr).forEach(e -> {
            String[] p = e.split("=");
            String fieldName = p[0];
            String value = p.length > 1 ? p[1] : "";
            queryParams.put(fieldName, value);
        });
        return queryParams;
    }

    public static Map<String, Object> getAllRequestParameter() {
        return RequestReader.getAllRequestParameter(RequestReader.getRequest());
    }

    public static Map<String, Object> getAllRequestParameter(HttpServletRequest request) {
        Map parameterMap = RequestReader.getRequest().getParameterMap();
        HashMap<String, Object> requestParameter = new HashMap<String, Object>();
        parameterMap.keySet().forEach(e -> {
            String[] strs = (String[])parameterMap.get(e);
            if (strs.length > 1) {
                List<String> list = Arrays.asList(strs);
                requestParameter.put((String)e, list);
            } else {
                requestParameter.put((String)e, strs[0]);
            }
        });
        return requestParameter;
    }

    public static HttpServletResponse getResponse() {
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        return requestAttributes != null ? requestAttributes.getResponse() : null;
    }

    public static HttpServletRequest getRequest() {
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        return requestAttributes != null ? requestAttributes.getRequest() : null;
    }
}

