/*
 * Decompiled with CFR 0.152.
 */
package com.gomyck.util.servlet;

import com.gomyck.util.CkContentType;
import com.gomyck.util.CkExcel;
import com.gomyck.util.CkFile;
import com.gomyck.util.CkId;
import com.gomyck.util.ObjectJudge;
import com.gomyck.util.log.logger.CkLogger;
import com.gomyck.util.serialize.CKJSON;
import com.gomyck.util.servlet.R;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class ResponseWriter {
    private static final Logger log = LoggerFactory.getLogger(ResponseWriter.class);

    public static boolean writeJSON(Object param) {
        return ResponseWriter.write(CKJSON.getInstance().toJsonString(param), CkContentType.JSON, true);
    }

    public static boolean write(String text) {
        return ResponseWriter.write(text, CkContentType.JSON, true);
    }

    public static boolean write(R r) {
        return ResponseWriter.write(CKJSON.getInstance().toJsonString(r), CkContentType.JSON, true);
    }

    public static boolean write(String text, CkContentType contentType) {
        return ResponseWriter.write(text, contentType, true);
    }

    public static boolean write(String text, CkContentType contentType, boolean ifClose) {
        HttpServletResponse response = ResponseWriter.getResponse();
        try {
            response.setCharacterEncoding(StandardCharsets.UTF_8.toString());
            response.setContentType(contentType.getTypeValue());
            PrintWriter writer = response.getWriter();
            writer.write(text);
            writer.flush();
            if (ifClose) {
                writer.close();
            }
            log.info("Response write: {}", (Object)text);
            return true;
        }
        catch (Exception e) {
            log.error(CkLogger.getTrace(e));
            return false;
        }
    }

    public static boolean writeByOutputStream(String text) {
        return ResponseWriter.writeByOutputStream(text, CkContentType.JSON, true);
    }

    public static boolean writeByOutputStream(String text, CkContentType contentType) {
        return ResponseWriter.writeByOutputStream(text, contentType, true);
    }

    public static boolean writeByOutputStream(String text, CkContentType contentType, boolean ifClose) {
        HttpServletResponse response = ResponseWriter.getResponse();
        try {
            response.setCharacterEncoding(StandardCharsets.UTF_8.toString());
            response.setContentType(contentType.getTypeValue());
            ServletOutputStream outputStream = response.getOutputStream();
            outputStream.write(text.getBytes());
            outputStream.flush();
            if (ifClose) {
                outputStream.close();
            }
            log.info("Response write: {}", (Object)text);
            return true;
        }
        catch (Exception e) {
            log.error(CkLogger.getTrace(e));
            return false;
        }
    }

    public static boolean writeExcel(CkExcel eu, String fileName) {
        return ResponseWriter.writeExcel(eu.getWorkBook(), MessageFormat.format("{0}.{1}", fileName, eu.getDownloadSuffix()));
    }

    public static boolean writeExcel(Workbook workbook, String fileName) {
        HttpServletResponse response = ResponseWriter.getResponse();
        try {
            if (workbook == null) {
                return false;
            }
            if (ObjectJudge.isNull((Object)fileName)) {
                fileName = CkId.getStringRandom(5);
            }
            response.setCharacterEncoding(StandardCharsets.UTF_8.toString());
            response.setHeader("Content-Disposition", "attachment; filename=\"" + ResponseWriter.fileNameWrapper(fileName) + "\"");
            String fileSuffixNameByFileName = CkFile.getFileSuffixNameByFileName(fileName);
            response.setContentType(CkContentType.getContentBySuffixName(fileSuffixNameByFileName).getTypeValue());
            ServletOutputStream out = response.getOutputStream();
            workbook.write((OutputStream)out);
            return true;
        }
        catch (Exception var5) {
            log.error(CkLogger.getTrace(var5));
            return false;
        }
    }

    public static boolean writeImg(byte[] img, String imgType) {
        HttpServletResponse response = ResponseWriter.getResponse();
        try {
            if (img == null) {
                return false;
            }
            response.setCharacterEncoding(StandardCharsets.UTF_8.toString());
            response.setHeader("Content-Disposition", "filename=\"" + CkId.getStringRandom(5) + "." + imgType + "\"");
            response.setContentType("image/" + imgType);
            ServletOutputStream out = response.getOutputStream();
            out.write(img);
            out.flush();
            out.close();
            return true;
        }
        catch (Exception e) {
            log.error(CkLogger.getTrace(e));
            return false;
        }
    }

    public static boolean writeFile(byte[] file, String fileName, CkContentType contentType) {
        return ResponseWriter.writeFile(file, fileName + "." + contentType.getTypeKey(), contentType.getTypeValue(), true);
    }

    public static boolean writeFile(byte[] file, String fileName, String contentType) {
        return ResponseWriter.writeFile(file, fileName, contentType, true);
    }

    public static boolean writeFile(byte[] file, String fileName, String contentType, boolean ifClose) {
        HttpServletResponse response = ResponseWriter.getResponse();
        try {
            if (file == null) {
                return false;
            }
            if (ObjectJudge.isNull((Object)fileName)) {
                fileName = CkId.getStringRandom(5);
            }
            response.setCharacterEncoding(StandardCharsets.UTF_8.toString());
            response.setHeader("Content-Disposition", "attachment; filename=\"" + ResponseWriter.fileNameWrapper(fileName) + "\"");
            response.setContentType(contentType);
            ServletOutputStream out = response.getOutputStream();
            out.write(file);
            out.flush();
            if (ifClose) {
                out.close();
            }
            return true;
        }
        catch (Exception e) {
            log.error(CkLogger.getTrace(e));
            return false;
        }
    }

    public static String fileNameWrapper(String filename) {
        HttpServletRequest request = ResponseWriter.getRequest();
        try {
            String userAgent = request.getHeader("User-Agent").toUpperCase();
            if (userAgent.indexOf("MSIE") > 0 || userAgent.indexOf("TRIDENT") > 0 || userAgent.indexOf("EDGE") > 0) {
                String wrapperName = URLEncoder.encode(filename, StandardCharsets.UTF_8.toString());
                return wrapperName.replace("+", " ");
            }
            String wrapperName = new String(filename.getBytes(StandardCharsets.UTF_8), "ISO8859-1");
            return wrapperName.replace(",", "");
        }
        catch (Exception e) {
            return "";
        }
    }

    public static HttpServletResponse getResponse() {
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletResponse response = requestAttributes.getResponse();
        return response;
    }

    public static HttpServletRequest getRequest() {
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        return requestAttributes.getRequest();
    }
}

