/*
 * Decompiled with CFR 0.152.
 */
package com.gomyck.util.servlet;

import com.gomyck.util.FieldUtil;
import com.gomyck.util.ObjectJudge;
import com.gomyck.util.serialize.CKJSON;
import com.gomyck.util.servlet.RequestReader;
import com.gomyck.util.servlet.TokenTake;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Base64;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenConverter {
    private static final Logger log = LoggerFactory.getLogger(TokenConverter.class);

    public static <T> T convertTokenInfo(Class<T> clazz, String token) {
        try {
            String pub = token.split("\\.")[1];
            String result = new String(Base64.getDecoder().decode(pub));
            T t = CKJSON.getInstance().parseObject(result, clazz);
            List<Field> allFields = FieldUtil.getAllFields(clazz);
            for (Field e : allFields) {
                if (e.getType() != String.class) continue;
                try {
                    Object invoke = FieldUtil.getMethod(clazz, e.getName()).invoke(t, new Object[0]);
                    if (!ObjectJudge.notNull(invoke)) continue;
                    try {
                        invoke = URLDecoder.decode(invoke.toString(), StandardCharsets.UTF_8.toString());
                    }
                    catch (Exception ex) {
                        invoke = invoke.toString();
                    }
                    FieldUtil.setMethod(clazz, e.getName()).invoke(t, invoke);
                }
                catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {}
            }
            return t;
        }
        catch (NullPointerException ignore) {
            return null;
        }
        catch (Exception e) {
            log.error(MessageFormat.format("token convert fail: exception is {0} | token is {1}", e.toString(), token));
            return null;
        }
    }

    public static <T> T getUserInfoByToken(Class<T> clazz, HttpServletRequest request) {
        String token = TokenTake.getToken(request);
        return TokenConverter.convertTokenInfo(clazz, token);
    }

    public static <T> T getUserInfoByToken(Class<T> clazz) {
        String token = TokenTake.getToken(RequestReader.getRequest());
        return TokenConverter.convertTokenInfo(clazz, token);
    }
}

