/*
 * Decompiled with CFR 0.152.
 */
package com.gomyck.util.servlet;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class WrapperHttpServletResponse
extends HttpServletResponseWrapper {
    private ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    private ServletOutputStream out = new WrapperOutputStream(this.buffer);

    public WrapperHttpServletResponse(HttpServletResponse httpServletResponse) {
        super(httpServletResponse);
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return this.out;
    }

    public void flushBuffer() throws IOException {
        if (this.out != null) {
            this.out.flush();
        }
    }

    public String getContent() throws IOException {
        this.buffer.flush();
        return new String(this.buffer.toByteArray(), "UTF-8");
    }

    public byte[] getContentByte() throws IOException {
        this.buffer.flush();
        return this.buffer.toByteArray();
    }

    class WrapperOutputStream
    extends ServletOutputStream {
        private ByteArrayOutputStream bos;

        public WrapperOutputStream(ByteArrayOutputStream bos) {
            this.bos = bos;
        }

        public void write(int b) throws IOException {
            this.bos.write(b);
        }

        public boolean isReady() {
            return false;
        }

        public void setWriteListener(WriteListener writeListener) {
        }
    }
}

