/*
 * Decompiled with CFR 0.152.
 */
package com.gomyck.util.validator;

import com.gomyck.util.validator.CkValidationException;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import java.util.Set;

public class CkValidator {
    private static final Validator validator;
    private static final ThreadLocal<Object> validateEntityHold;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void validateEntity(Object object, Class<?> ... groups) {
        try {
            validateEntityHold.set(object);
            Set constraintViolations = validator.validate(object, (Class[])groups);
            if (!constraintViolations.isEmpty()) {
                StringBuilder msg = new StringBuilder();
                int index = 1;
                int size = constraintViolations.size();
                for (ConstraintViolation constraint : constraintViolations) {
                    msg.append(constraint.getMessage());
                    if (index == size) continue;
                    msg.append("\r\n");
                    ++index;
                }
                throw new CkValidationException(msg.toString());
            }
        }
        finally {
            validateEntityHold.remove();
        }
    }

    public static Object getValidateEntity() {
        return validateEntityHold.get();
    }

    static {
        validateEntityHold = new ThreadLocal();
        validator = Validation.buildDefaultValidatorFactory().getValidator();
    }
}

