/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.tracing;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.tracing.ApiTracer;
import com.google.api.gax.tracing.MethodName;
import com.google.api.gax.tracing.MetricsRecorder;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.threeten.bp.Duration;

@BetaApi
@InternalApi
public class MetricsTracer
implements ApiTracer {
    private static final String STATUS_ATTRIBUTE = "status";
    private Stopwatch attemptTimer;
    private final Stopwatch operationTimer = Stopwatch.createStarted();
    private final Map<String, String> attributes = new HashMap<String, String>();
    private MetricsRecorder metricsRecorder;

    public MetricsTracer(MethodName methodName, MetricsRecorder metricsRecorder) {
        this.attributes.put("method_name", methodName.toString());
        this.metricsRecorder = metricsRecorder;
    }

    @Override
    public void operationSucceeded() {
        this.attributes.put(STATUS_ATTRIBUTE, StatusCode.Code.OK.toString());
        this.metricsRecorder.recordOperationLatency(this.operationTimer.elapsed(TimeUnit.MILLISECONDS), this.attributes);
        this.metricsRecorder.recordOperationCount(1L, this.attributes);
    }

    @Override
    public void operationCancelled() {
        this.attributes.put(STATUS_ATTRIBUTE, StatusCode.Code.CANCELLED.toString());
        this.metricsRecorder.recordOperationLatency(this.operationTimer.elapsed(TimeUnit.MILLISECONDS), this.attributes);
        this.metricsRecorder.recordOperationCount(1L, this.attributes);
    }

    @Override
    public void operationFailed(Throwable error) {
        this.attributes.put(STATUS_ATTRIBUTE, MetricsTracer.extractStatus(error));
        this.metricsRecorder.recordOperationLatency(this.operationTimer.elapsed(TimeUnit.MILLISECONDS), this.attributes);
        this.metricsRecorder.recordOperationCount(1L, this.attributes);
    }

    @Override
    public void attemptStarted(Object request, int attemptNumber) {
        this.attemptTimer = Stopwatch.createStarted();
    }

    @Override
    public void attemptSucceeded() {
        this.attributes.put(STATUS_ATTRIBUTE, StatusCode.Code.OK.toString());
        this.metricsRecorder.recordAttemptLatency(this.attemptTimer.elapsed(TimeUnit.MILLISECONDS), this.attributes);
        this.metricsRecorder.recordAttemptCount(1L, this.attributes);
    }

    @Override
    public void attemptCancelled() {
        this.attributes.put(STATUS_ATTRIBUTE, StatusCode.Code.CANCELLED.toString());
        this.metricsRecorder.recordAttemptLatency(this.attemptTimer.elapsed(TimeUnit.MILLISECONDS), this.attributes);
        this.metricsRecorder.recordAttemptCount(1L, this.attributes);
    }

    @Override
    public void attemptFailed(Throwable error, Duration delay) {
        this.attributes.put(STATUS_ATTRIBUTE, MetricsTracer.extractStatus(error));
        this.metricsRecorder.recordAttemptLatency(this.attemptTimer.elapsed(TimeUnit.MILLISECONDS), this.attributes);
        this.metricsRecorder.recordAttemptCount(1L, this.attributes);
    }

    @Override
    public void attemptFailedRetriesExhausted(Throwable error) {
        this.attributes.put(STATUS_ATTRIBUTE, MetricsTracer.extractStatus(error));
        this.metricsRecorder.recordAttemptLatency(this.attemptTimer.elapsed(TimeUnit.MILLISECONDS), this.attributes);
        this.metricsRecorder.recordAttemptCount(1L, this.attributes);
    }

    @Override
    public void attemptPermanentFailure(Throwable error) {
        this.attributes.put(STATUS_ATTRIBUTE, MetricsTracer.extractStatus(error));
        this.metricsRecorder.recordAttemptLatency(this.attemptTimer.elapsed(TimeUnit.MILLISECONDS), this.attributes);
        this.metricsRecorder.recordAttemptCount(1L, this.attributes);
    }

    @VisibleForTesting
    static String extractStatus(@Nullable Throwable error) {
        if (error == null) {
            return StatusCode.Code.OK.toString();
        }
        String statusString = error instanceof CancellationException ? StatusCode.Code.CANCELLED.toString() : (error instanceof ApiException ? ((ApiException)error).getStatusCode().getCode().toString() : StatusCode.Code.UNKNOWN.toString());
        return statusString;
    }

    public void addAttributes(String key, String value) {
        this.attributes.put(key, value);
    }

    @VisibleForTesting
    Map<String, String> getAttributes() {
        return this.attributes;
    }
}

