/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.discoveryengine.v1.CollectionName;
import com.google.cloud.discoveryengine.v1.CreateDataStoreMetadata;
import com.google.cloud.discoveryengine.v1.CreateDataStoreRequest;
import com.google.cloud.discoveryengine.v1.DataStore;
import com.google.cloud.discoveryengine.v1.DataStoreName;
import com.google.cloud.discoveryengine.v1.DataStoreServiceSettings;
import com.google.cloud.discoveryengine.v1.DeleteDataStoreMetadata;
import com.google.cloud.discoveryengine.v1.DeleteDataStoreRequest;
import com.google.cloud.discoveryengine.v1.GetDataStoreRequest;
import com.google.cloud.discoveryengine.v1.ListDataStoresRequest;
import com.google.cloud.discoveryengine.v1.ListDataStoresResponse;
import com.google.cloud.discoveryengine.v1.UpdateDataStoreRequest;
import com.google.cloud.discoveryengine.v1.stub.DataStoreServiceStub;
import com.google.cloud.discoveryengine.v1.stub.DataStoreServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class DataStoreServiceClient
implements BackgroundResource {
    private final DataStoreServiceSettings settings;
    private final DataStoreServiceStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final DataStoreServiceClient create() throws IOException {
        return DataStoreServiceClient.create(DataStoreServiceSettings.newBuilder().build());
    }

    public static final DataStoreServiceClient create(DataStoreServiceSettings settings) throws IOException {
        return new DataStoreServiceClient(settings);
    }

    public static final DataStoreServiceClient create(DataStoreServiceStub stub) {
        return new DataStoreServiceClient(stub);
    }

    protected DataStoreServiceClient(DataStoreServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((DataStoreServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected DataStoreServiceClient(DataStoreServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final DataStoreServiceSettings getSettings() {
        return this.settings;
    }

    public DataStoreServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final OperationFuture<DataStore, CreateDataStoreMetadata> createDataStoreAsync(CollectionName parent, DataStore dataStore, String dataStoreId) {
        CreateDataStoreRequest request = CreateDataStoreRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setDataStore(dataStore).setDataStoreId(dataStoreId).build();
        return this.createDataStoreAsync(request);
    }

    public final OperationFuture<DataStore, CreateDataStoreMetadata> createDataStoreAsync(String parent, DataStore dataStore, String dataStoreId) {
        CreateDataStoreRequest request = CreateDataStoreRequest.newBuilder().setParent(parent).setDataStore(dataStore).setDataStoreId(dataStoreId).build();
        return this.createDataStoreAsync(request);
    }

    public final OperationFuture<DataStore, CreateDataStoreMetadata> createDataStoreAsync(CreateDataStoreRequest request) {
        return this.createDataStoreOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateDataStoreRequest, DataStore, CreateDataStoreMetadata> createDataStoreOperationCallable() {
        return this.stub.createDataStoreOperationCallable();
    }

    public final UnaryCallable<CreateDataStoreRequest, Operation> createDataStoreCallable() {
        return this.stub.createDataStoreCallable();
    }

    public final DataStore getDataStore(DataStoreName name) {
        GetDataStoreRequest request = GetDataStoreRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getDataStore(request);
    }

    public final DataStore getDataStore(String name) {
        GetDataStoreRequest request = GetDataStoreRequest.newBuilder().setName(name).build();
        return this.getDataStore(request);
    }

    public final DataStore getDataStore(GetDataStoreRequest request) {
        return (DataStore)this.getDataStoreCallable().call((Object)request);
    }

    public final UnaryCallable<GetDataStoreRequest, DataStore> getDataStoreCallable() {
        return this.stub.getDataStoreCallable();
    }

    public final ListDataStoresPagedResponse listDataStores(CollectionName parent) {
        ListDataStoresRequest request = ListDataStoresRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listDataStores(request);
    }

    public final ListDataStoresPagedResponse listDataStores(String parent) {
        ListDataStoresRequest request = ListDataStoresRequest.newBuilder().setParent(parent).build();
        return this.listDataStores(request);
    }

    public final ListDataStoresPagedResponse listDataStores(ListDataStoresRequest request) {
        return (ListDataStoresPagedResponse)((Object)this.listDataStoresPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListDataStoresRequest, ListDataStoresPagedResponse> listDataStoresPagedCallable() {
        return this.stub.listDataStoresPagedCallable();
    }

    public final UnaryCallable<ListDataStoresRequest, ListDataStoresResponse> listDataStoresCallable() {
        return this.stub.listDataStoresCallable();
    }

    public final OperationFuture<Empty, DeleteDataStoreMetadata> deleteDataStoreAsync(DataStoreName name) {
        DeleteDataStoreRequest request = DeleteDataStoreRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteDataStoreAsync(request);
    }

    public final OperationFuture<Empty, DeleteDataStoreMetadata> deleteDataStoreAsync(String name) {
        DeleteDataStoreRequest request = DeleteDataStoreRequest.newBuilder().setName(name).build();
        return this.deleteDataStoreAsync(request);
    }

    public final OperationFuture<Empty, DeleteDataStoreMetadata> deleteDataStoreAsync(DeleteDataStoreRequest request) {
        return this.deleteDataStoreOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteDataStoreRequest, Empty, DeleteDataStoreMetadata> deleteDataStoreOperationCallable() {
        return this.stub.deleteDataStoreOperationCallable();
    }

    public final UnaryCallable<DeleteDataStoreRequest, Operation> deleteDataStoreCallable() {
        return this.stub.deleteDataStoreCallable();
    }

    public final DataStore updateDataStore(DataStore dataStore, FieldMask updateMask) {
        UpdateDataStoreRequest request = UpdateDataStoreRequest.newBuilder().setDataStore(dataStore).setUpdateMask(updateMask).build();
        return this.updateDataStore(request);
    }

    public final DataStore updateDataStore(UpdateDataStoreRequest request) {
        return (DataStore)this.updateDataStoreCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateDataStoreRequest, DataStore> updateDataStoreCallable() {
        return this.stub.updateDataStoreCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListDataStoresFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDataStoresRequest, ListDataStoresResponse, DataStore, ListDataStoresPage, ListDataStoresFixedSizeCollection> {
        private ListDataStoresFixedSizeCollection(List<ListDataStoresPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListDataStoresFixedSizeCollection createEmptyCollection() {
            return new ListDataStoresFixedSizeCollection(null, 0);
        }

        protected ListDataStoresFixedSizeCollection createCollection(List<ListDataStoresPage> pages, int collectionSize) {
            return new ListDataStoresFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListDataStoresPage
    extends AbstractPage<ListDataStoresRequest, ListDataStoresResponse, DataStore, ListDataStoresPage> {
        private ListDataStoresPage(PageContext<ListDataStoresRequest, ListDataStoresResponse, DataStore> context, ListDataStoresResponse response) {
            super(context, (Object)response);
        }

        private static ListDataStoresPage createEmptyPage() {
            return new ListDataStoresPage(null, null);
        }

        protected ListDataStoresPage createPage(PageContext<ListDataStoresRequest, ListDataStoresResponse, DataStore> context, ListDataStoresResponse response) {
            return new ListDataStoresPage(context, response);
        }

        public ApiFuture<ListDataStoresPage> createPageAsync(PageContext<ListDataStoresRequest, ListDataStoresResponse, DataStore> context, ApiFuture<ListDataStoresResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListDataStoresPagedResponse
    extends AbstractPagedListResponse<ListDataStoresRequest, ListDataStoresResponse, DataStore, ListDataStoresPage, ListDataStoresFixedSizeCollection> {
        public static ApiFuture<ListDataStoresPagedResponse> createAsync(PageContext<ListDataStoresRequest, ListDataStoresResponse, DataStore> context, ApiFuture<ListDataStoresResponse> futureResponse) {
            ApiFuture<ListDataStoresPage> futurePage = ListDataStoresPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListDataStoresPagedResponse((ListDataStoresPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListDataStoresPagedResponse(ListDataStoresPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListDataStoresFixedSizeCollection.createEmptyCollection());
        }
    }
}

