/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javac.code;

import java.io.IOException;
import java.nio.file.Path;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.openjdk.javax.lang.model.SourceVersion;
import org.openjdk.javax.tools.JavaFileManager;
import org.openjdk.javax.tools.JavaFileObject;
import org.openjdk.javax.tools.StandardJavaFileManager;
import org.openjdk.javax.tools.StandardLocation;
import org.openjdk.tools.javac.code.Kinds;
import org.openjdk.tools.javac.code.Scope;
import org.openjdk.tools.javac.code.Symbol;
import org.openjdk.tools.javac.code.Symtab;
import org.openjdk.tools.javac.comp.Annotate;
import org.openjdk.tools.javac.file.JRTIndex;
import org.openjdk.tools.javac.file.JavacFileManager;
import org.openjdk.tools.javac.jvm.ClassReader;
import org.openjdk.tools.javac.jvm.Profile;
import org.openjdk.tools.javac.main.Option;
import org.openjdk.tools.javac.platform.PlatformDescription;
import org.openjdk.tools.javac.util.Assert;
import org.openjdk.tools.javac.util.Context;
import org.openjdk.tools.javac.util.Convert;
import org.openjdk.tools.javac.util.Dependencies;
import org.openjdk.tools.javac.util.JCDiagnostic;
import org.openjdk.tools.javac.util.List;
import org.openjdk.tools.javac.util.Log;
import org.openjdk.tools.javac.util.Name;
import org.openjdk.tools.javac.util.Names;
import org.openjdk.tools.javac.util.Options;

public class ClassFinder {
    protected static final Context.Key<ClassFinder> classFinderKey = new Context.Key();
    ClassReader reader;
    private final Annotate annotate;
    boolean verbose;
    private boolean cacheCompletionFailure;
    protected boolean preferSource;
    protected boolean userPathsFirst;
    private boolean allowSigFiles;
    final Log log;
    Symtab syms;
    final Names names;
    final Name completionFailureName;
    private final JavaFileManager fileManager;
    private final Dependencies dependencies;
    JCDiagnostic.Factory diagFactory;
    public Symbol.Completer sourceCompleter = Symbol.Completer.NULL_COMPLETER;
    protected JavaFileObject currentClassFile = null;
    protected Symbol currentOwner = null;
    private final Profile profile;
    private final JRTIndex jrtIndex;
    private final Symbol.Completer thisCompleter = this::complete;
    private Map<Symbol.PackageSymbol, Long> supplementaryFlags;
    private final Symbol.CompletionFailure cachedCompletionFailure = new Symbol.CompletionFailure(null, (JCDiagnostic)null);
    protected JavaFileManager.Location currentLoc;
    private boolean verbosePath;
    private boolean preferCurrent;

    public Symbol.Completer getCompleter() {
        return this.thisCompleter;
    }

    public static ClassFinder instance(Context context) {
        ClassFinder classFinder = context.get(classFinderKey);
        if (classFinder == null) {
            classFinder = new ClassFinder(context);
        }
        return classFinder;
    }

    protected ClassFinder(Context context) {
        JavacFileManager javacFileManager;
        this.cachedCompletionFailure.setStackTrace(new StackTraceElement[0]);
        this.verbosePath = true;
        context.put(classFinderKey, this);
        this.reader = ClassReader.instance(context);
        this.names = Names.instance(context);
        this.syms = Symtab.instance(context);
        this.fileManager = context.get(JavaFileManager.class);
        this.dependencies = Dependencies.instance(context);
        if (this.fileManager == null) {
            throw new AssertionError((Object)"FileManager initialization error");
        }
        this.diagFactory = JCDiagnostic.Factory.instance(context);
        this.log = Log.instance(context);
        this.annotate = Annotate.instance(context);
        Options options = Options.instance(context);
        this.verbose = options.isSet(Option.VERBOSE);
        this.cacheCompletionFailure = options.isUnset("dev");
        this.preferSource = "source".equals(options.get("-Xprefer"));
        this.userPathsFirst = options.isSet(Option.XXUSERPATHSFIRST);
        this.allowSigFiles = context.get(PlatformDescription.class) != null;
        this.completionFailureName = options.isSet("failcomplete") ? this.names.fromString(options.get("failcomplete")) : null;
        JavaFileManager javaFileManager = context.get(JavaFileManager.class);
        boolean bl = javaFileManager instanceof JavacFileManager ? (javacFileManager = (JavacFileManager)javaFileManager).isDefaultBootClassPath() && javacFileManager.isSymbolFileEnabled() : (javaFileManager.getClass().getName().equals("org.openjdk.tools.sjavac.comp.SmartFileManager") ? !options.isSet("ignore.symbol.file") : false);
        this.jrtIndex = bl && JRTIndex.isAvailable() ? JRTIndex.getSharedInstance() : null;
        this.profile = Profile.instance(context);
    }

    long getSupplementaryFlags(Symbol.ClassSymbol classSymbol) {
        Long l;
        if (this.jrtIndex == null || !this.jrtIndex.isInJRT(classSymbol.classfile) || classSymbol.name == this.names.module_info) {
            return 0L;
        }
        if (this.supplementaryFlags == null) {
            this.supplementaryFlags = new HashMap<Symbol.PackageSymbol, Long>();
        }
        if ((l = this.supplementaryFlags.get(classSymbol.packge())) == null) {
            long l2 = 0L;
            try {
                JRTIndex.CtSym ctSym = this.jrtIndex.getCtSym(classSymbol.packge().flatName());
                Profile profile = Profile.DEFAULT;
                if (ctSym.proprietary) {
                    l2 |= 0x4000000000L;
                }
                if (ctSym.minProfile != null) {
                    profile = Profile.lookup(ctSym.minProfile);
                }
                if (this.profile != Profile.DEFAULT && profile.value > this.profile.value) {
                    l2 |= 0x200000000000L;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            l = l2;
            this.supplementaryFlags.put(classSymbol.packge(), l);
        }
        return l;
    }

    private void complete(Symbol symbol) throws Symbol.CompletionFailure {
        if (symbol.kind == Kinds.Kind.TYP) {
            try {
                Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)symbol;
                this.dependencies.push(classSymbol, Dependencies.CompletionCause.CLASS_READER);
                this.annotate.blockAnnotations();
                classSymbol.members_field = new Scope.ErrorScope(classSymbol);
                this.completeOwners(classSymbol.owner);
                this.completeEnclosing(classSymbol);
                this.fillIn(classSymbol);
            }
            finally {
                this.annotate.unblockAnnotationsNoFlush();
                this.dependencies.pop();
            }
        }
        if (symbol.kind == Kinds.Kind.PCK) {
            Symbol.PackageSymbol packageSymbol = (Symbol.PackageSymbol)symbol;
            try {
                this.fillIn(packageSymbol);
            }
            catch (IOException iOException) {
                throw new Symbol.CompletionFailure(symbol, iOException.getLocalizedMessage()).initCause(iOException);
            }
        }
        if (!this.reader.filling) {
            this.annotate.flush();
        }
    }

    private void completeOwners(Symbol symbol) {
        if (symbol.kind != Kinds.Kind.PCK) {
            this.completeOwners(symbol.owner);
        }
        symbol.complete();
    }

    private void completeEnclosing(Symbol.ClassSymbol classSymbol) {
        if (classSymbol.owner.kind == Kinds.Kind.PCK) {
            Symbol symbol = classSymbol.owner;
            for (Name name : Convert.enclosingCandidates(Convert.shortName(classSymbol.name))) {
                Symbol symbol2 = symbol.members().findFirst(name);
                if (symbol2 == null) {
                    symbol2 = this.syms.getClass(classSymbol.packge().modle, Symbol.TypeSymbol.formFlatName(name, symbol));
                }
                if (symbol2 == null) continue;
                symbol2.complete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fillIn(Symbol.ClassSymbol classSymbol) {
        if (this.completionFailureName == classSymbol.fullname) {
            throw new Symbol.CompletionFailure((Symbol)classSymbol, "user-selected completion failure by class name");
        }
        this.currentOwner = classSymbol;
        JavaFileObject javaFileObject = classSymbol.classfile;
        if (javaFileObject != null) {
            JavaFileObject javaFileObject2 = this.currentClassFile;
            try {
                if (this.reader.filling) {
                    Assert.error("Filling " + javaFileObject.toUri() + " during " + javaFileObject2);
                }
                this.currentClassFile = javaFileObject;
                if (this.verbose) {
                    this.log.printVerbose("loading", this.currentClassFile.getName());
                }
                if (javaFileObject.getKind() == JavaFileObject.Kind.CLASS || javaFileObject.getKind() == JavaFileObject.Kind.OTHER) {
                    this.reader.readClassFile(classSymbol);
                    classSymbol.flags_field |= this.getSupplementaryFlags(classSymbol);
                }
                if (!this.sourceCompleter.isTerminal()) {
                    this.sourceCompleter.complete(classSymbol);
                }
                throw new IllegalStateException("Source completer required to read " + javaFileObject.toUri());
            }
            finally {
                this.currentClassFile = javaFileObject2;
            }
        } else {
            throw this.classFileNotFound(classSymbol);
        }
    }

    private Symbol.CompletionFailure classFileNotFound(Symbol.ClassSymbol classSymbol) {
        JCDiagnostic jCDiagnostic = this.diagFactory.fragment("class.file.not.found", classSymbol.flatname);
        return this.newCompletionFailure(classSymbol, jCDiagnostic);
    }

    private Symbol.CompletionFailure newCompletionFailure(Symbol.TypeSymbol typeSymbol, JCDiagnostic jCDiagnostic) {
        if (!this.cacheCompletionFailure) {
            return new Symbol.CompletionFailure((Symbol)typeSymbol, jCDiagnostic);
        }
        Symbol.CompletionFailure completionFailure = this.cachedCompletionFailure;
        completionFailure.sym = typeSymbol;
        completionFailure.diag = jCDiagnostic;
        return completionFailure;
    }

    public Symbol.ClassSymbol loadClass(Symbol.ModuleSymbol moduleSymbol, Name name) throws Symbol.CompletionFailure {
        Assert.checkNonNull(moduleSymbol);
        Name name2 = Convert.packagePart(name);
        Symbol.PackageSymbol packageSymbol = this.syms.lookupPackage(moduleSymbol, name2);
        Assert.checkNonNull(packageSymbol.modle, () -> "msym=" + moduleSymbol + "; flatName=" + name);
        boolean bl = this.syms.getClass(packageSymbol.modle, name) == null;
        Symbol.ClassSymbol classSymbol = this.syms.enterClass(packageSymbol.modle, name);
        if (classSymbol.members_field == null) {
            try {
                classSymbol.complete();
            }
            catch (Symbol.CompletionFailure completionFailure) {
                if (bl) {
                    this.syms.removeClass(packageSymbol.modle, name);
                }
                throw completionFailure;
            }
        }
        return classSymbol;
    }

    protected void includeClassFile(Symbol.PackageSymbol packageSymbol, JavaFileObject javaFileObject) {
        Symbol.ClassSymbol classSymbol;
        Object object;
        if ((packageSymbol.flags_field & 0x800000L) == 0L) {
            object = packageSymbol;
            while (object != null && object.kind == Kinds.Kind.PCK) {
                object.flags_field |= 0x800000L;
                object = object.owner;
            }
        }
        int n = (object = javaFileObject.getKind()) == JavaFileObject.Kind.CLASS || object == JavaFileObject.Kind.OTHER ? 0x2000000 : 0x4000000;
        String string = this.fileManager.inferBinaryName(this.currentLoc, javaFileObject);
        int n2 = string.lastIndexOf(".");
        Name name = this.names.fromString(string.substring(n2 + 1));
        boolean bl = name == this.names.package_info;
        Symbol.ClassSymbol classSymbol2 = classSymbol = bl ? packageSymbol.package_info : (Symbol.ClassSymbol)packageSymbol.members_field.findFirst(name);
        if (classSymbol == null) {
            classSymbol = this.syms.enterClass(packageSymbol.modle, name, packageSymbol);
            if (classSymbol.classfile == null) {
                classSymbol.classfile = javaFileObject;
            }
            if (bl) {
                packageSymbol.package_info = classSymbol;
            } else if (classSymbol.owner == packageSymbol) {
                packageSymbol.members_field.enter(classSymbol);
            }
        } else if (!this.preferCurrent && classSymbol.classfile != null && (classSymbol.flags_field & (long)n) == 0L && (classSymbol.flags_field & 0x6000000L) != 0L) {
            classSymbol.classfile = this.preferredFileObject(javaFileObject, classSymbol.classfile);
        }
        classSymbol.flags_field |= (long)n;
    }

    protected JavaFileObject preferredFileObject(JavaFileObject javaFileObject, JavaFileObject javaFileObject2) {
        long l;
        if (this.preferSource) {
            return javaFileObject.getKind() == JavaFileObject.Kind.SOURCE ? javaFileObject : javaFileObject2;
        }
        long l2 = javaFileObject.getLastModified();
        return l2 > (l = javaFileObject2.getLastModified()) ? javaFileObject : javaFileObject2;
    }

    protected EnumSet<JavaFileObject.Kind> getPackageFileKinds() {
        return EnumSet.of(JavaFileObject.Kind.CLASS, JavaFileObject.Kind.SOURCE);
    }

    protected void extraFileActions(Symbol.PackageSymbol packageSymbol, JavaFileObject javaFileObject) {
    }

    private void fillIn(Symbol.PackageSymbol packageSymbol) throws IOException {
        if (packageSymbol.members_field == null) {
            packageSymbol.members_field = Scope.WriteableScope.create(packageSymbol);
        }
        Symbol.ModuleSymbol moduleSymbol = packageSymbol.modle;
        Assert.checkNonNull(moduleSymbol, packageSymbol::toString);
        moduleSymbol.complete();
        if (moduleSymbol == this.syms.noModule) {
            this.preferCurrent = false;
            if (this.userPathsFirst) {
                this.scanUserPaths(packageSymbol, true);
                this.preferCurrent = true;
                this.scanPlatformPath(packageSymbol);
            } else {
                this.scanPlatformPath(packageSymbol);
                this.scanUserPaths(packageSymbol, true);
            }
        } else if (moduleSymbol.classLocation == StandardLocation.CLASS_PATH) {
            this.scanUserPaths(packageSymbol, moduleSymbol.sourceLocation == StandardLocation.SOURCE_PATH);
        } else {
            this.scanModulePaths(packageSymbol, moduleSymbol);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanModulePaths(Symbol.PackageSymbol packageSymbol, Symbol.ModuleSymbol moduleSymbol) throws IOException {
        EnumSet<JavaFileObject.Kind> enumSet = this.getPackageFileKinds();
        EnumSet<JavaFileObject.Kind> enumSet2 = EnumSet.copyOf(enumSet);
        enumSet2.remove((Object)JavaFileObject.Kind.SOURCE);
        boolean bl = !enumSet2.isEmpty();
        EnumSet<JavaFileObject.Kind> enumSet3 = EnumSet.copyOf(enumSet);
        enumSet3.remove((Object)JavaFileObject.Kind.CLASS);
        boolean bl2 = !enumSet3.isEmpty();
        String string = packageSymbol.fullname.toString();
        JavaFileManager.Location location = moduleSymbol.classLocation;
        JavaFileManager.Location location2 = moduleSymbol.sourceLocation;
        JavaFileManager.Location location3 = moduleSymbol.patchLocation;
        JavaFileManager.Location location4 = moduleSymbol.patchOutputLocation;
        boolean bl3 = this.preferCurrent;
        try {
            this.preferCurrent = false;
            if (bl && location4 != null) {
                this.fillIn(packageSymbol, location4, this.list(location4, packageSymbol, string, enumSet2));
            }
            if ((bl || bl2) && location3 != null) {
                EnumSet<JavaFileObject.Kind> enumSet4 = EnumSet.noneOf(JavaFileObject.Kind.class);
                enumSet4.addAll(enumSet2);
                enumSet4.addAll(enumSet3);
                this.fillIn(packageSymbol, location3, this.list(location3, packageSymbol, string, enumSet4));
            }
            this.preferCurrent = true;
            if (bl && location != null) {
                this.fillIn(packageSymbol, location, this.list(location, packageSymbol, string, enumSet2));
            }
            if (bl2 && location2 != null) {
                this.fillIn(packageSymbol, location2, this.list(location2, packageSymbol, string, enumSet3));
            }
        }
        finally {
            this.preferCurrent = bl3;
        }
    }

    private void scanUserPaths(Symbol.PackageSymbol packageSymbol, boolean bl) throws IOException {
        Object object;
        boolean bl2;
        EnumSet<JavaFileObject.Kind> enumSet = this.getPackageFileKinds();
        EnumSet<JavaFileObject.Kind> enumSet2 = EnumSet.copyOf(enumSet);
        enumSet2.remove((Object)JavaFileObject.Kind.SOURCE);
        boolean bl3 = !enumSet2.isEmpty();
        EnumSet<JavaFileObject.Kind> enumSet3 = EnumSet.copyOf(enumSet);
        enumSet3.remove((Object)JavaFileObject.Kind.CLASS);
        boolean bl4 = !enumSet3.isEmpty();
        boolean bl5 = bl2 = bl && this.fileManager.hasLocation(StandardLocation.SOURCE_PATH);
        if (this.verbose && this.verbosePath && this.fileManager instanceof StandardJavaFileManager) {
            List<Object> list;
            object = (StandardJavaFileManager)this.fileManager;
            if (bl2 && bl4) {
                list = List.nil();
                for (Path path : object.getLocationAsPaths(StandardLocation.SOURCE_PATH)) {
                    list = list.prepend(path);
                }
                this.log.printVerbose("sourcepath", list.reverse().toString());
            } else if (bl4) {
                list = List.nil();
                for (Path path : object.getLocationAsPaths(StandardLocation.CLASS_PATH)) {
                    list = list.prepend(path);
                }
                this.log.printVerbose("sourcepath", list.reverse().toString());
            }
            if (bl3) {
                list = List.nil();
                for (Path path : object.getLocationAsPaths(StandardLocation.PLATFORM_CLASS_PATH)) {
                    list = list.prepend(path);
                }
                for (Path path : object.getLocationAsPaths(StandardLocation.CLASS_PATH)) {
                    list = list.prepend(path);
                }
                this.log.printVerbose("classpath", list.reverse().toString());
            }
        }
        object = packageSymbol.fullname.toString();
        if (bl4 && !bl2) {
            this.fillIn(packageSymbol, StandardLocation.CLASS_PATH, this.list(StandardLocation.CLASS_PATH, packageSymbol, (String)object, enumSet));
        } else {
            if (bl3) {
                this.fillIn(packageSymbol, StandardLocation.CLASS_PATH, this.list(StandardLocation.CLASS_PATH, packageSymbol, (String)object, enumSet2));
            }
            if (bl4) {
                this.fillIn(packageSymbol, StandardLocation.SOURCE_PATH, this.list(StandardLocation.SOURCE_PATH, packageSymbol, (String)object, enumSet3));
            }
        }
    }

    private void scanPlatformPath(Symbol.PackageSymbol packageSymbol) throws IOException {
        this.fillIn(packageSymbol, StandardLocation.PLATFORM_CLASS_PATH, this.list(StandardLocation.PLATFORM_CLASS_PATH, packageSymbol, packageSymbol.fullname.toString(), this.allowSigFiles ? EnumSet.of(JavaFileObject.Kind.CLASS, JavaFileObject.Kind.OTHER) : EnumSet.of(JavaFileObject.Kind.CLASS)));
    }

    private void fillIn(Symbol.PackageSymbol packageSymbol, JavaFileManager.Location location, Iterable<JavaFileObject> iterable) {
        this.currentLoc = location;
        block4: for (JavaFileObject javaFileObject : iterable) {
            switch (javaFileObject.getKind()) {
                case OTHER: {
                    if (!this.isSigFile(location, javaFileObject)) {
                        this.extraFileActions(packageSymbol, javaFileObject);
                        continue block4;
                    }
                }
                case CLASS: 
                case SOURCE: {
                    String string = this.fileManager.inferBinaryName(this.currentLoc, javaFileObject);
                    String string2 = string.substring(string.lastIndexOf(".") + 1);
                    if (!SourceVersion.isIdentifier(string2) && !string2.equals("package-info")) continue block4;
                    this.includeClassFile(packageSymbol, javaFileObject);
                    continue block4;
                }
            }
            this.extraFileActions(packageSymbol, javaFileObject);
        }
    }

    boolean isSigFile(JavaFileManager.Location location, JavaFileObject javaFileObject) {
        return location == StandardLocation.PLATFORM_CLASS_PATH && this.allowSigFiles && javaFileObject.getName().endsWith(".sig");
    }

    Iterable<JavaFileObject> list(JavaFileManager.Location location, final Symbol.PackageSymbol packageSymbol, String string, final Set<JavaFileObject.Kind> set) throws IOException {
        final Iterable<JavaFileObject> iterable = this.fileManager.list(location, string, EnumSet.allOf(JavaFileObject.Kind.class), false);
        return () -> new Iterator<JavaFileObject>(){
            private JavaFileObject next;
            private final Iterator original;
            {
                this.original = iterable.iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.next == null) {
                    while (this.original.hasNext()) {
                        JavaFileObject javaFileObject = (JavaFileObject)this.original.next();
                        if (javaFileObject.getKind() != JavaFileObject.Kind.CLASS && javaFileObject.getKind() != JavaFileObject.Kind.SOURCE && !ClassFinder.this.isSigFile(ClassFinder.this.currentLoc, javaFileObject)) {
                            packageSymbol.flags_field |= 0x100000000000000L;
                        }
                        if (!set.contains((Object)javaFileObject.getKind())) continue;
                        this.next = javaFileObject;
                        break;
                    }
                }
                return this.next != null;
            }

            @Override
            public JavaFileObject next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                JavaFileObject javaFileObject = this.next;
                this.next = null;
                return javaFileObject;
            }
        };
    }

    public static class BadEnclosingMethodAttr
    extends BadClassFile {
        private static final long serialVersionUID = 0L;

        public BadEnclosingMethodAttr(Symbol.TypeSymbol typeSymbol, JavaFileObject javaFileObject, JCDiagnostic jCDiagnostic, JCDiagnostic.Factory factory) {
            super(typeSymbol, javaFileObject, jCDiagnostic, factory);
        }
    }

    public static class BadClassFile
    extends Symbol.CompletionFailure {
        private static final long serialVersionUID = 0L;

        public BadClassFile(Symbol.TypeSymbol typeSymbol, JavaFileObject javaFileObject, JCDiagnostic jCDiagnostic, JCDiagnostic.Factory factory) {
            super((Symbol)typeSymbol, BadClassFile.createBadClassFileDiagnostic(javaFileObject, jCDiagnostic, factory));
        }

        private static JCDiagnostic createBadClassFileDiagnostic(JavaFileObject javaFileObject, JCDiagnostic jCDiagnostic, JCDiagnostic.Factory factory) {
            String string = javaFileObject.getKind() == JavaFileObject.Kind.SOURCE ? "bad.source.file.header" : "bad.class.file.header";
            return factory.fragment(string, javaFileObject, jCDiagnostic);
        }
    }
}

