/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;

public class DangerousPermissionCombination
extends OpcodeStackDetector {
    private BugReporter bugReporter;

    public DangerousPermissionCombination(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    private void reportBug(String permission, String target) {
        BugInstance bug = new BugInstance((Detector)this, "DANGEROUS_PERMISSION_COMBINATION", 2).addClassAndMethod((PreorderVisitor)this).addString(permission).addString(target).addSourceLine((BytecodeScanningDetector)this);
        this.bugReporter.reportBug(bug);
    }

    public void sawOpcode(int seen) {
        if (seen == 183 && "<init>".equals(this.getNameConstantOperand())) {
            String stringParam;
            ClassDescriptor cd = this.getClassDescriptorOperand();
            if (cd != null && "Ljava/lang/reflect/ReflectPermission;".equals(cd.getSignature())) {
                String stringParam2 = (String)this.stack.getStackItem(0).getConstant();
                if (stringParam2 != null && "suppressAccessChecks".equals(stringParam2)) {
                    this.reportBug("ReflectPermission", "suppressAccessChecks");
                }
            } else if (cd != null && "Ljava/lang/RuntimePermission;".equals(cd.getSignature()) && (stringParam = (String)this.stack.getStackItem(0).getConstant()) != null && "createClassLoader".equals(stringParam)) {
                this.reportBug("RuntimePermission", "createClassLoader");
            }
        }
    }
}

