/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs;

public class RegexRedosAnalyzer {
    private static final char[] OPENING_CHAR = new char[]{'(', '['};
    private static final char[] CLOSING_CHAR = new char[]{')', ']'};
    private static final char[] PLUS_CHAR = new char[]{'+', '*', '?'};
    private boolean vulnerable = false;

    public boolean isVulnerable() {
        return this.vulnerable;
    }

    public void analyseRegexString(String regex) {
        if (regex.length() > 0) {
            this.recurAnalyseRegex(regex, regex.length() - 1, 0);
        }
    }

    private int recurAnalyseRegex(String regex, int startPosition, int level) {
        if (level == 2) {
            this.vulnerable = true;
            return 0;
        }
        boolean openingMode = false;
        for (int i = startPosition; i >= 0; --i) {
            if (this.isChar(regex, i, OPENING_CHAR)) {
                return i;
            }
            if (!this.isChar(regex, i, CLOSING_CHAR)) continue;
            int newLevel = level;
            if (i + 1 < regex.length() && this.isChar(regex, i + 1, PLUS_CHAR)) {
                ++newLevel;
            }
            openingMode = true;
            if ((i = this.recurAnalyseRegex(regex, i - 1, newLevel)) != -1) continue;
            return 0;
        }
        return 0;
    }

    private boolean isChar(String value, int position, char[] charToTest) {
        char actualChar = value.charAt(position);
        boolean oneCharFound = false;
        for (char ch : charToTest) {
            if (actualChar != ch) continue;
            oneCharFound = true;
            break;
        }
        return oneCharFound && (position == 0 || value.charAt(position - 1) != '\\');
    }
}

