/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.crypto;

import com.h3xstream.findsecbugs.common.ByteCode;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Location;
import java.util.Iterator;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.BIPUSH;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.INVOKESTATIC;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.Instruction;

public class InsufficientKeySizeBlowfishDetector
implements Detector {
    private static final String BLOWFISH_KEY_SIZE_TYPE = "BLOWFISH_KEY_SIZE";
    private BugReporter bugReporter;

    public InsufficientKeySizeBlowfishDetector(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        Method[] methodList;
        JavaClass javaClass = classContext.getJavaClass();
        for (Method m : methodList = javaClass.getMethods()) {
            try {
                this.analyzeMethod(m, classContext);
            }
            catch (CFGBuilderException cFGBuilderException) {
            }
            catch (DataflowAnalysisException dataflowAnalysisException) {
                // empty catch block
            }
        }
    }

    private void analyzeMethod(Method m, ClassContext classContext) throws CFGBuilderException, DataflowAnalysisException {
        boolean createBlowfishKeyGen = false;
        boolean initializeWeakKeyLength = false;
        Location locationWeakness = null;
        ConstantPoolGen cpg = classContext.getConstantPoolGen();
        CFG cfg = classContext.getCFG(m);
        Iterator i = cfg.locationIterator();
        while (i.hasNext()) {
            BIPUSH push;
            INVOKESTATIC invoke;
            Location location = (Location)i.next();
            Instruction inst = location.getHandle().getInstruction();
            if (inst instanceof INVOKESTATIC) {
                String value;
                invoke = (INVOKESTATIC)inst;
                if (!"javax.crypto.KeyGenerator".equals(invoke.getClassName(cpg)) || !"getInstance".equals(invoke.getMethodName(cpg)) || !"Blowfish".equals(value = ByteCode.getConstantLDC(location.getHandle().getPrev(), cpg, String.class))) continue;
                createBlowfishKeyGen = true;
                continue;
            }
            if (!(inst instanceof INVOKEVIRTUAL) || !"javax.crypto.KeyGenerator".equals((invoke = (INVOKEVIRTUAL)inst).getClassName(cpg)) || !"init".equals(invoke.getMethodName(cpg))) continue;
            Number n = null;
            if ("(I)V".equals(invoke.getSignature(cpg))) {
                n = ByteCode.getPushNumber(location.getHandle().getPrev());
            } else if ("(ILjava/security/SecureRandom;)V".equals(invoke.getSignature(cpg)) && (push = ByteCode.getPrevInstruction(location.getHandle(), BIPUSH.class)) != null) {
                n = push.getValue();
            }
            if (n == null || n.intValue() >= 128) continue;
            initializeWeakKeyLength = true;
            locationWeakness = location;
        }
        if (createBlowfishKeyGen && initializeWeakKeyLength) {
            JavaClass clz = classContext.getJavaClass();
            this.bugReporter.reportBug(new BugInstance((Detector)this, BLOWFISH_KEY_SIZE_TYPE, 2).addClass(clz).addMethod(clz, m).addSourceLine(classContext, m, locationWeakness));
        }
    }

    public void report() {
    }
}

