/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.crypto;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;

public class WeakTLSDetector
extends OpcodeStackDetector {
    private static final String DEFAULT_HTTP_CLIENT = "DEFAULT_HTTP_CLIENT";
    private static final String SSL_CONTEXT = "SSL_CONTEXT";
    private BugReporter bugReporter;

    public WeakTLSDetector(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void sawOpcode(int seen) {
        OpcodeStack.Item item;
        String sslContextName;
        if (seen == 183 && this.getClassConstantOperand().equals("org/apache/http/impl/client/DefaultHttpClient") && this.getNameConstantOperand().equals("<init>") && this.getSigConstantOperand().equals("()V")) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, DEFAULT_HTTP_CLIENT, 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
        }
        if (seen == 184 && this.getClassConstantOperand().equals("javax/net/ssl/SSLContext") && this.getNameConstantOperand().equals("getInstance") && this.getSigConstantOperand().equals("(Ljava/lang/String;)Ljavax/net/ssl/SSLContext;") && (sslContextName = (String)(item = this.stack.getStackItem(0)).getConstant()) != null && sslContextName.equalsIgnoreCase("SSL")) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, SSL_CONTEXT, 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
        }
    }
}

