/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.endpoint;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;

public class ServletEndpointDetector
extends OpcodeStackDetector {
    private static final String GET_PARAMETER_TYPE = "SERVLET_PARAMETER";
    private static final String CONTENT_TYPE = "SERVLET_CONTENT_TYPE";
    private static final String SERVER_NAME_TYPE = "SERVLET_SERVER_NAME";
    private static final String SESSION_ID_TYPE = "SERVLET_SESSION_ID";
    private static final String QUERY_STRING_TYPE = "SERVLET_QUERY_STRING";
    private static final String HEADER_TYPE = "SERVLET_HEADER";
    private static final String HEADER_REFERER_TYPE = "SERVLET_HEADER_REFERER";
    private static final String HEADER_USER_AGENT_TYPE = "SERVLET_HEADER_USER_AGENT";
    private BugReporter bugReporter;

    public ServletEndpointDetector(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void sawOpcode(int seen) {
        if (seen == 185 && (this.getClassConstantOperand().equals("javax/servlet/ServletRequest") || this.getClassConstantOperand().equals("javax/servlet/http/HttpServletRequest"))) {
            if (this.getNameConstantOperand().equals("getParameter") || this.getNameConstantOperand().equals("getParameterValues") || this.getNameConstantOperand().equals("getParameterMap") || this.getNameConstantOperand().equals("getParameterNames")) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, GET_PARAMETER_TYPE, 3).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this).addString(this.getNameConstantOperand()));
            } else if (this.getNameConstantOperand().equals("getContentType")) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, CONTENT_TYPE, 3).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
            } else if (this.getNameConstantOperand().equals("getServerName")) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, SERVER_NAME_TYPE, 3).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
            } else if (this.getNameConstantOperand().equals("getRequestedSessionId")) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, SESSION_ID_TYPE, 3).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
            } else if (this.getNameConstantOperand().equals("getQueryString")) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, QUERY_STRING_TYPE, 3).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
            } else if (this.getNameConstantOperand().equals("getHeader")) {
                OpcodeStack.Item top = this.stack.getStackItem(0);
                String value = (String)top.getConstant();
                if ("Host".equals(value)) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, SERVER_NAME_TYPE, 3).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                } else if ("Referer".equalsIgnoreCase(value)) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, HEADER_REFERER_TYPE, 3).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                } else if ("User-Agent".equalsIgnoreCase(value)) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, HEADER_USER_AGENT_TYPE, 3).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                } else {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, HEADER_TYPE, 3).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                }
            }
        }
    }
}

