/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.file;

import com.h3xstream.findsecbugs.common.ByteCode;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Location;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.GETSTATIC;
import org.apache.bcel.generic.INVOKESTATIC;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.LDC;

public class OverlyPermissiveFilePermissionDetector
implements Detector {
    private static final boolean DEBUG = false;
    public static final String OVERLY_PERMISSIVE_FILE_PERMISSION = "OVERLY_PERMISSIVE_FILE_PERMISSION";
    private final BugReporter bugReporter;

    public OverlyPermissiveFilePermissionDetector(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        Method[] methodList;
        JavaClass javaClass = classContext.getJavaClass();
        for (Method m : methodList = javaClass.getMethods()) {
            try {
                this.analyzeMethod(m, classContext);
            }
            catch (CFGBuilderException | DataflowAnalysisException e) {
                AnalysisContext.logError((String)"Cannot analyze method", (Exception)e);
            }
        }
    }

    public void report() {
    }

    private void analyzeMethod(Method m, ClassContext classContext) throws CFGBuilderException, DataflowAnalysisException {
        ConstantPoolGen cpg = classContext.getConstantPoolGen();
        CFG cfg = classContext.getCFG(m);
        boolean addIntToSet = false;
        boolean callSetPermissions = false;
        ArrayList<Location> locationFound = new ArrayList<Location>();
        Iterator i = cfg.locationIterator();
        while (i.hasNext()) {
            String permissionString;
            LDC loadConst;
            GETSTATIC getstatic;
            String fieldName;
            Location location = this.nextLocation(i, cpg);
            Instruction inst = location.getHandle().getInstruction();
            if (inst instanceof GETSTATIC && ((fieldName = (getstatic = (GETSTATIC)inst).getName(cpg)).endsWith("OTHERS_READ") || fieldName.endsWith("OTHERS_WRITE") || fieldName.endsWith("OTHERS_EXECUTE"))) {
                addIntToSet = true;
                locationFound.add(location);
            }
            if (!(inst instanceof INVOKESTATIC)) continue;
            INVOKESTATIC invoke = (INVOKESTATIC)inst;
            if ("java.nio.file.Files".equals(invoke.getClassName(cpg)) && "setPosixFilePermissions".equals(invoke.getMethodName(cpg))) {
                callSetPermissions = true;
            }
            if (!"java.nio.file.attribute.PosixFilePermissions".equals(invoke.getClassName(cpg)) || !"fromString".equals(invoke.getMethodName(cpg)) || (loadConst = ByteCode.getPrevInstruction(location.getHandle(), LDC.class)) == null || (permissionString = (String)loadConst.getValue(cpg)).endsWith("---")) continue;
            JavaClass clz = classContext.getJavaClass();
            this.bugReporter.reportBug(new BugInstance((Detector)this, OVERLY_PERMISSIVE_FILE_PERMISSION, 2).addClass(clz).addMethod(clz, m).addSourceLine(classContext, m, location));
        }
        if (addIntToSet && callSetPermissions && locationFound != null) {
            JavaClass clz = classContext.getJavaClass();
            for (Location loc : locationFound) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, OVERLY_PERMISSIVE_FILE_PERMISSION, 2).addClass(clz).addMethod(clz, m).addSourceLine(classContext, m, loc));
            }
        }
    }

    private Location nextLocation(Iterator<Location> i, ConstantPoolGen cpg) {
        Location loc = i.next();
        return loc;
    }
}

