/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.password;

import com.h3xstream.findsecbugs.common.matcher.InstructionDSL;
import com.h3xstream.findsecbugs.common.matcher.InvokeMatcherBuilder;
import com.h3xstream.findsecbugs.injection.InjectionPoint;
import com.h3xstream.findsecbugs.password.AbstractHardcodePasswordInMapDetector;
import edu.umd.cs.findbugs.BugReporter;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;

public class HardcodePasswordInMapDetector
extends AbstractHardcodePasswordInMapDetector {
    private static final String HARD_CODE_PASSWORD_TYPE = "HARD_CODE_PASSWORD";
    private static final InvokeMatcherBuilder MAP_PUT_METHOD = InstructionDSL.invokeInstruction().atMethod("put").withArgs("(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
    private static final InvokeMatcherBuilder MAP_PUT_IF_ABSENT_METHOD = InstructionDSL.invokeInstruction().atMethod("putIfAbsent").withArgs("(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
    private static final InvokeMatcherBuilder HASHTABLE_SET_PROPERTY = InstructionDSL.invokeInstruction().atMethod("setProperty").withArgs("(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/Object;");

    public HardcodePasswordInMapDetector(BugReporter bugReporter) {
        super(bugReporter);
    }

    @Override
    protected InjectionPoint getInjectionPoint(InvokeInstruction invoke, ConstantPoolGen cpg, InstructionHandle handle) {
        assert (invoke != null && cpg != null);
        if (MAP_PUT_METHOD.matches((Instruction)invoke, cpg) || MAP_PUT_IF_ABSENT_METHOD.matches((Instruction)invoke, cpg) || HASHTABLE_SET_PROPERTY.matches((Instruction)invoke, cpg)) {
            return new InjectionPoint(new int[]{0}, HARD_CODE_PASSWORD_TYPE);
        }
        return InjectionPoint.NONE;
    }
}

