/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.scala;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;

public class SslDisablerDetector
extends OpcodeStackDetector {
    private static final String WEAK_TRUST_MANAGER_TYPE = "WEAK_TRUST_MANAGER";
    private static final String WEAK_HOSTNAME_VERIFIER_TYPE = "WEAK_HOSTNAME_VERIFIER";
    private BugReporter bugReporter;

    public SslDisablerDetector(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void sawOpcode(int seen) {
        if (seen == 182 && this.getClassConstantOperand().endsWith("SecurityBypasser$") && this.getNameConstantOperand().equals("destroyAllSSLSecurityForTheEntireVMForever")) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, WEAK_TRUST_MANAGER_TYPE, 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
        }
        if (seen == 178) {
            XField field = this.getXFieldOperand();
            if (field == null) {
                return;
            }
            if (field.getClassName().endsWith("SecurityBypasser$AllHosts$") && field.getName().equals("MODULE$")) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, WEAK_HOSTNAME_VERIFIER_TYPE, 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
            } else if (field.getClassName().endsWith("SecurityBypasser$AllTM$") && field.getName().equals("MODULE$")) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, WEAK_TRUST_MANAGER_TYPE, 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
            }
        }
    }
}

