/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.serial;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.FieldAnnotation;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Location;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.ElementValuePair;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.MethodGen;

public class UnsafeJacksonDeserializationDetector
implements Detector {
    private static final String DESERIALIZATION_TYPE = "JACKSON_UNSAFE_DESERIALIZATION";
    private BugReporter bugReporter;
    private static final List<String> ANNOTATION_TYPES = Arrays.asList("Lcom/fasterxml/jackson/annotation/JsonTypeInfo;");
    private static final List<String> VULNERABLE_USE_NAMES = Arrays.asList("CLASS", "MINIMAL_CLASS");
    private static final List<String> OBJECT_MAPPER_CLASSES = Arrays.asList("com.fasterxml.jackson.databind.ObjectMapper", "org.codehaus.jackson.map.ObjectMapper");

    public UnsafeJacksonDeserializationDetector(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        JavaClass javaClass = classContext.getJavaClass();
        if (OBJECT_MAPPER_CLASSES.contains(javaClass.getClassName())) {
            return;
        }
        for (Field field : javaClass.getFields()) {
            this.analyzeField(field, javaClass);
        }
        for (Field field : javaClass.getMethods()) {
            try {
                this.analyzeMethod((Method)field, classContext);
            }
            catch (CFGBuilderException | DataflowAnalysisException throwable) {
                // empty catch block
            }
        }
    }

    private void analyzeField(Field field, JavaClass javaClass) {
        for (AnnotationEntry annotation : field.getAnnotationEntries()) {
            if (!ANNOTATION_TYPES.contains(annotation.getAnnotationType()) && !annotation.getAnnotationType().contains("JsonTypeInfo")) continue;
            for (ElementValuePair elementValuePair : annotation.getElementValuePairs()) {
                if (!"use".equals(elementValuePair.getNameString()) || !VULNERABLE_USE_NAMES.contains(elementValuePair.getValue().stringifyValue())) continue;
                this.bugReporter.reportBug(new BugInstance((Detector)this, DESERIALIZATION_TYPE, 1).addClass(javaClass).addString(javaClass.getClassName() + " on field " + field.getName() + " of type " + field.getType() + " annotated with " + annotation.toShortString()).addField(FieldAnnotation.fromBCELField((JavaClass)javaClass, (Field)field)).addString(""));
            }
        }
    }

    private void analyzeMethod(Method m, ClassContext classContext) throws CFGBuilderException, DataflowAnalysisException {
        MethodGen methodGen = classContext.getMethodGen(m);
        ConstantPoolGen cpg = classContext.getConstantPoolGen();
        CFG cfg = classContext.getCFG(m);
        if (methodGen == null || methodGen.getInstructionList() == null) {
            return;
        }
        Iterator i = cfg.locationIterator();
        while (i.hasNext()) {
            InvokeInstruction invoke;
            String methodName;
            Location location = (Location)i.next();
            Instruction inst = location.getHandle().getInstruction();
            if (!(inst instanceof InvokeInstruction) || !"enableDefaultTyping".equals(methodName = (invoke = (InvokeInstruction)inst).getMethodName(cpg))) continue;
            JavaClass clz = classContext.getJavaClass();
            this.bugReporter.reportBug(new BugInstance((Detector)this, DESERIALIZATION_TYPE, 1).addClass(clz).addMethod(clz, m).addCalledMethod(cpg, invoke).addSourceLine(classContext, m, location));
        }
    }

    public void report() {
    }
}

