/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.taintanalysis;

import com.h3xstream.findsecbugs.taintanalysis.Taint;
import com.h3xstream.findsecbugs.taintanalysis.TaintTypeConfig;
import java.io.IOException;
import java.util.regex.Pattern;

public class TaintFieldConfig
implements TaintTypeConfig {
    public static final Taint.State DEFAULT_TAINT_STATE = Taint.State.NULL;
    private Taint.State taintState = DEFAULT_TAINT_STATE;
    private String typeSignature;
    private static final Pattern typePattern;
    private static final Pattern taintConfigPattern;

    public static boolean accepts(String typeSignature, String taintConfig) {
        return typePattern.matcher(typeSignature).matches() && taintConfigPattern.matcher(taintConfig).matches();
    }

    @Override
    public TaintFieldConfig load(String taintConfig) throws IOException {
        if (taintConfig == null) {
            throw new NullPointerException("Taint config is null");
        }
        if ((taintConfig = taintConfig.trim()).isEmpty()) {
            throw new IOException("No taint class config specified");
        }
        if (!taintConfig.isEmpty()) {
            this.taintState = Taint.State.valueOf(taintConfig);
        }
        return this;
    }

    public Taint.State getTaintState() {
        return this.taintState;
    }

    public Taint.State getTaintState(Taint.State defaultState) {
        if (this.taintState.equals((Object)DEFAULT_TAINT_STATE)) {
            return defaultState;
        }
        return this.taintState;
    }

    public void setTypeSignature(String typeSignature) {
        this.typeSignature = typeSignature;
    }

    public String getTypeSignature() {
        return this.typeSignature;
    }

    static {
        String javaIdentifierRegex = "\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*";
        String classWithPackageRegex = javaIdentifierRegex + "(\\/" + javaIdentifierRegex + ")*";
        String typeRegex = classWithPackageRegex + "\\." + javaIdentifierRegex;
        typePattern = Pattern.compile(typeRegex);
        String taintConfigRegex = "([A-Z_]+)";
        taintConfigPattern = Pattern.compile(taintConfigRegex);
    }
}

