/*
 * Decompiled with CFR 0.152.
 */
package com.hortonworks.registries.auth;

import com.hortonworks.registries.auth.Login;
import java.security.PrivilegedAction;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.security.sasl.RealmCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLogin
implements Login {
    private static final Logger log = LoggerFactory.getLogger(AbstractLogin.class);
    protected String loginContextName;
    protected LoginContext loginContext;
    protected static final String JAAS_CONFIG_SYSTEM_PROPERTY = "java.security.auth.login.config";
    protected Configuration jaasConfiguration;

    @Override
    public void configure(Map<String, ?> configs, String loginContextName) {
        this.loginContextName = loginContextName;
    }

    public void configure(Map<String, ?> configs, String loginContextName, Configuration jaasConfiguration) {
        this.loginContextName = loginContextName;
        this.jaasConfiguration = jaasConfiguration;
    }

    @Override
    public LoginContext login() throws LoginException {
        String jaasConfigFile = System.getProperty(JAAS_CONFIG_SYSTEM_PROPERTY);
        if (this.jaasConfiguration != null) {
            this.loginContext = new LoginContext(this.loginContextName, null, new LoginCallbackHandler(), this.jaasConfiguration);
        } else {
            if (jaasConfigFile == null) {
                log.error("System property java.security.auth.login.config for jaas config file is not set, using default JAAS configuration.");
            }
            log.debug("Defaulting to static JAAS Config for {}", (Object)this.loginContextName);
            this.loginContext = new LoginContext(this.loginContextName, new LoginCallbackHandler());
        }
        this.loginContext.login();
        log.info("Successfully logged in.");
        return this.loginContext;
    }

    @Override
    public <T> T doAction(PrivilegedAction<T> action) throws LoginException {
        return Subject.doAs(this.loginContext == null ? null : this.loginContext.getSubject(), action);
    }

    public static class LoginCallbackHandler
    implements CallbackHandler {
        @Override
        public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
            for (Callback callback : callbacks) {
                if (callback instanceof NameCallback) {
                    NameCallback nc = (NameCallback)callback;
                    nc.setName(nc.getDefaultName());
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    String errorMessage = "Could not login: the client is being asked for a password, but this  module does not currently support obtaining a password from the user.";
                    throw new UnsupportedCallbackException(callback, errorMessage);
                }
                if (callback instanceof RealmCallback) {
                    RealmCallback rc = (RealmCallback)callback;
                    rc.setText(rc.getDefaultText());
                    continue;
                }
                throw new UnsupportedCallbackException(callback, "Unrecognized Login callback");
            }
        }
    }
}

