/*
 * Decompiled with CFR 0.152.
 */
package com.hortonworks.registries.auth;

import com.hortonworks.registries.auth.AbstractLogin;
import com.hortonworks.registries.auth.util.Shell;
import com.hortonworks.registries.auth.util.Utils;
import java.security.PrivilegedAction;
import java.util.Date;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerberosLogin
extends AbstractLogin {
    private static final Logger log = LoggerFactory.getLogger(KerberosLogin.class);
    private static final Random RNG = new Random();
    public static final String KINIT_CMD = "kinit.cmd";
    public static final String TICKET_RENEW_WINDOW_FACTOR = "ticket.renew.window.factor";
    public static final String TICKET_RENEW_JITTER = "ticket.renew.jitter";
    public static final String MIN_TIME_BEFORE_RELOGIN = "min.time.before.relogin";
    private Thread t;
    private boolean isKrbTicket;
    private boolean isUsingTicketCache;
    private String principal;
    private double ticketRenewWindowFactor = 0.8;
    private double ticketRenewJitter = 0.05;
    private long minTimeBeforeRelogin = 60000L;
    private String kinitCmd = "/usr/bin/kinit";
    private ReentrantReadWriteLock tgtRenewalLock = new ReentrantReadWriteLock(true);
    private long tgtRenewalTimeoutMS;
    private static final long DEFAULT_TGT_RENEWAL_TIMEOUT_MS = 180000L;

    @Override
    public void configure(Map<String, ?> configs, String loginContextName) {
        super.configure(configs, loginContextName);
        if (configs.get(TICKET_RENEW_WINDOW_FACTOR) != null) {
            this.ticketRenewWindowFactor = Double.parseDouble((String)configs.get(TICKET_RENEW_WINDOW_FACTOR));
        }
        if (configs.get(TICKET_RENEW_JITTER) != null) {
            this.ticketRenewJitter = Double.parseDouble((String)configs.get(TICKET_RENEW_JITTER));
        }
        if (configs.get(MIN_TIME_BEFORE_RELOGIN) != null) {
            this.minTimeBeforeRelogin = Long.parseLong((String)configs.get(MIN_TIME_BEFORE_RELOGIN));
        }
        if (configs.get(KINIT_CMD) != null) {
            this.kinitCmd = (String)configs.get(KINIT_CMD);
        }
    }

    @Override
    public void configure(Map<String, ?> configs, String loginContextName, Configuration jaasConfig) {
        super.configure(configs, loginContextName, jaasConfig);
        if (configs.get(TICKET_RENEW_WINDOW_FACTOR) != null) {
            this.ticketRenewWindowFactor = Double.parseDouble((String)configs.get(TICKET_RENEW_WINDOW_FACTOR));
        }
        if (configs.get(TICKET_RENEW_JITTER) != null) {
            this.ticketRenewJitter = Double.parseDouble((String)configs.get(TICKET_RENEW_JITTER));
        }
        if (configs.get(MIN_TIME_BEFORE_RELOGIN) != null) {
            this.minTimeBeforeRelogin = Long.parseLong((String)configs.get(MIN_TIME_BEFORE_RELOGIN));
        }
        if (configs.get(KINIT_CMD) != null) {
            this.kinitCmd = (String)configs.get(KINIT_CMD);
        }
    }

    public KerberosLogin() {
        this.tgtRenewalTimeoutMS = 180000L;
    }

    public KerberosLogin(long tgtRenewalTimeoutMS) {
        this.tgtRenewalTimeoutMS = tgtRenewalTimeoutMS;
    }

    @Override
    public LoginContext login() throws LoginException {
        AppConfigurationEntry[] entries;
        super.login();
        boolean bl = this.isKrbTicket = !this.loginContext.getSubject().getPrivateCredentials(KerberosTicket.class).isEmpty();
        if (!this.isKrbTicket) {
            log.info("It is not a Kerberos ticket");
            this.t = null;
            return this.loginContext;
        }
        log.info("It is a Kerberos ticket");
        AppConfigurationEntry[] appConfigurationEntryArray = entries = this.jaasConfiguration != null ? this.jaasConfiguration.getAppConfigurationEntry(this.loginContextName) : Configuration.getConfiguration().getAppConfigurationEntry(this.loginContextName);
        if (entries.length == 0) {
            this.isUsingTicketCache = false;
            this.principal = null;
        } else {
            AppConfigurationEntry entry = entries[0];
            if (entry.getOptions().get("useTicketCache") != null) {
                String val = (String)entry.getOptions().get("useTicketCache");
                this.isUsingTicketCache = val.equals("true");
            } else {
                this.isUsingTicketCache = false;
            }
            this.principal = entry.getOptions().get("principal") != null ? (String)entry.getOptions().get("principal") : null;
        }
        KerberosTicket tgt = this.getTGT();
        if (tgt != null) {
            if (this.isUsingTicketCache && tgt.getRenewTill() != null && tgt.getRenewTill().getTime() < tgt.getEndTime().getTime()) {
                log.warn("The TGT cannot be renewed beyond the next expiry date: {}. This process will not be able to authenticate new clients after that time. Ask your system administrator to either increase the 'renew until' time by doing : 'modprinc -maxrenewlife {} ' within kadmin, or instead, to generate a keytab for {}. Because the TGT's expiry cannot be further extended by refreshing, exiting refresh thread now.", new Object[]{new Date(tgt.getEndTime().getTime()), this.principal, this.principal});
            } else {
                this.spawnReloginThread();
            }
        } else {
            log.warn("No tgt found for principal {}. Hence not spawning auto relogin thread.", (Object)this.principal);
        }
        return this.loginContext;
    }

    @Override
    public void close() {
        if (this.t != null && this.t.isAlive()) {
            this.t.interrupt();
            try {
                this.t.join();
            }
            catch (InterruptedException e) {
                log.warn("Error while waiting for Login thread to shutdown: " + e, (Throwable)e);
            }
        }
    }

    private void spawnReloginThread() {
        this.t = Utils.newThread("kerberos-refresh-thread", new Runnable(){

            @Override
            public void run() {
                log.info("TGT refresh thread started.");
                while (true) {
                    KerberosTicket tgt = KerberosLogin.this.getTGT();
                    long now = System.currentTimeMillis();
                    long nextRefresh = KerberosLogin.this.getRefreshTime(tgt);
                    long expiry = tgt.getEndTime().getTime();
                    if (now + KerberosLogin.this.minTimeBeforeRelogin <= expiry) {
                        if (nextRefresh < now + KerberosLogin.this.minTimeBeforeRelogin) {
                            log.warn("TGT refresh thread time adjusted from {} to {} since the former is sooner than the minimum refresh interval ({} seconds) from now.", new Object[]{new Date(nextRefresh), new Date(now + KerberosLogin.this.minTimeBeforeRelogin), KerberosLogin.this.minTimeBeforeRelogin / 1000L});
                        }
                        nextRefresh = Math.max(nextRefresh, now + KerberosLogin.this.minTimeBeforeRelogin);
                    }
                    Date nextRefreshDate = new Date(nextRefresh);
                    if (nextRefresh > expiry) {
                        log.error("Next refresh: {} is later than expiry {}. This may indicate a clock skew problem.Check that this host and the KDC hosts' clocks are in sync. Exiting refresh thread.", (Object)nextRefreshDate, (Object)new Date(expiry));
                        return;
                    }
                    if (now < nextRefresh) {
                        log.info("TGT refresh sleeping until: {}", (Object)nextRefreshDate);
                        try {
                            Thread.sleep(nextRefresh - now);
                        }
                        catch (InterruptedException ie) {
                            log.warn("TGT renewal thread has been interrupted and will exit.");
                            return;
                        }
                    } else {
                        log.error("NextRefresh: {} is in the past: exiting refresh thread. Check clock sync between this host and KDC - (KDC's clock is likely ahead of this host). Manual intervention will be required for this client to successfully authenticate. Exiting refresh thread.", (Object)nextRefreshDate);
                        return;
                    }
                    if (KerberosLogin.this.isUsingTicketCache) {
                        String kinitArgs = "-R";
                        try {
                            log.debug("Running ticket cache refresh command: {} {}", (Object)KerberosLogin.this.kinitCmd, (Object)kinitArgs);
                            Shell.execCommand(KerberosLogin.this.kinitCmd, kinitArgs);
                        }
                        catch (Exception e) {
                            log.warn("Could not renew TGT due to problem running shell command: '" + KerberosLogin.this.kinitCmd + " " + kinitArgs + "'; exception was: " + e + ". Exiting refresh thread.", (Throwable)e);
                            return;
                        }
                    }
                    try {
                        KerberosLogin.this.reLogin();
                    }
                    catch (LoginException le) {
                        log.error("Failed to refresh TGT: refresh thread exiting now.", (Throwable)le);
                        return;
                    }
                }
            }
        }, true);
        this.t.start();
    }

    private long getRefreshTime(KerberosTicket tgt) {
        long start = tgt.getStartTime().getTime();
        long expires = tgt.getEndTime().getTime();
        log.info("TGT valid starting at: {}", (Object)tgt.getStartTime());
        log.info("TGT expires: {}", (Object)tgt.getEndTime());
        long proposedSleepInterval = (long)((double)(expires - start) * (this.ticketRenewWindowFactor + this.ticketRenewJitter * RNG.nextDouble()));
        long proposedRefresh = start + proposedSleepInterval;
        if (proposedRefresh > expires) {
            return System.currentTimeMillis();
        }
        return proposedRefresh;
    }

    private KerberosTicket getTGT() {
        Set<KerberosTicket> tickets = this.loginContext.getSubject().getPrivateCredentials(KerberosTicket.class);
        for (KerberosTicket ticket : tickets) {
            KerberosPrincipal server = ticket.getServer();
            if (!server.getName().equals("krbtgt/" + server.getRealm() + "@" + server.getRealm())) continue;
            log.debug("Found TGT with client principal '{}' and server principal '{}'.", (Object)ticket.getClient().getName(), (Object)ticket.getServer().getName());
            return ticket;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T doAction(PrivilegedAction<T> action) throws LoginException {
        ReentrantReadWriteLock.ReadLock readLock = this.tgtRenewalLock.readLock();
        try {
            if (readLock.tryLock(this.tgtRenewalTimeoutMS, TimeUnit.MILLISECONDS)) {
                T result;
                try {
                    result = super.doAction(action);
                }
                finally {
                    readLock.unlock();
                }
                return result;
            }
            throw new LoginException("Timed out while the client was waiting for Kerberos TGT renewal");
        }
        catch (InterruptedException e) {
            throw new LoginException("Error while the client was waiting for Kerberos TGT renewal : " + e.getLocalizedMessage());
        }
    }

    private void reLogin() throws LoginException {
        block6: {
            ReentrantReadWriteLock.WriteLock writeLock = this.tgtRenewalLock.writeLock();
            try {
                if (writeLock.tryLock(this.tgtRenewalTimeoutMS, TimeUnit.MILLISECONDS)) {
                    try {
                        log.info("Initiating logout for {}", (Object)this.principal);
                        this.loginContext.logout();
                        this.loginContext = new LoginContext(this.loginContextName, this.loginContext.getSubject());
                        log.info("Initiating re-login for {}", (Object)this.principal);
                        this.loginContext.login();
                        log.info("Successfully logged in from auto relogin thread");
                        break block6;
                    }
                    finally {
                        writeLock.unlock();
                    }
                }
                throw new LoginException("Timed out while waiting to acquire a lock for renewing Kerberos TGT");
            }
            catch (InterruptedException e) {
                throw new LoginException("Error while acquiring lock for renewing Kerberos TGT : " + e.getMessage());
            }
        }
    }
}

