/*
 * Decompiled with CFR 0.152.
 */
package com.hortonworks.registries.auth.server;

import com.hortonworks.registries.auth.PlatformName;
import com.hortonworks.registries.auth.client.AuthenticationException;
import com.hortonworks.registries.auth.server.AuthenticationHandler;
import com.hortonworks.registries.auth.server.AuthenticationToken;
import com.hortonworks.registries.auth.util.KerberosName;
import com.hortonworks.registries.auth.util.KerberosUtil;
import com.hortonworks.registries.auth.util.Utils;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.Oid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerberosAuthenticationHandler
implements AuthenticationHandler {
    private static Logger LOG = LoggerFactory.getLogger(KerberosAuthenticationHandler.class);
    public static final String TYPE = "kerberos";
    public static final String PRINCIPAL = "kerberos.principal";
    public static final String KEYTAB = "kerberos.keytab";
    public static final String ENABLE_TRUSTED_PROXY = "enable.trusted.proxy";
    public static final String NAME_RULES = "kerberos.name.rules";
    public static final String QUERY_STRING_DELIMITER = "&";
    public static final String DOAS_QUERY_STRING = "doAs=";
    private String type;
    private String keytab;
    private GSSManager gssManager;
    private Subject serverSubject = new Subject();
    private List<LoginContext> loginContexts = new ArrayList<LoginContext>();
    private String[] nonBrowserUserAgents;
    private boolean trustedProxyEnabled = false;
    private ProxyUserAuthorization proxyUserAuthorization;

    public KerberosAuthenticationHandler() {
        this(TYPE);
    }

    public KerberosAuthenticationHandler(String type) {
        this.type = type;
    }

    @Override
    public void init(Properties config) throws ServletException {
        try {
            String nameRules;
            String[] spnegoPrincipals;
            this.nonBrowserUserAgents = Utils.getNonBrowserUserAgents(config.getProperty("non-browser.user-agents", "java,curl,wget,perl,Jersey"));
            String principal = config.getProperty(PRINCIPAL);
            if (principal == null || principal.trim().length() == 0) {
                throw new ServletException("Principal not defined in configuration");
            }
            this.keytab = config.getProperty(KEYTAB, this.keytab);
            if (this.keytab == null || this.keytab.trim().length() == 0) {
                throw new ServletException("Keytab not defined in configuration");
            }
            if (!new File(this.keytab).exists()) {
                throw new ServletException("Keytab does not exist: " + this.keytab);
            }
            if (principal.equals("*")) {
                spnegoPrincipals = KerberosUtil.getPrincipalNames(this.keytab, Pattern.compile("HTTP/.*"));
                if (spnegoPrincipals.length == 0) {
                    throw new ServletException("Principals do not exist in the keytab");
                }
            } else {
                spnegoPrincipals = new String[]{principal};
            }
            if ((nameRules = config.getProperty(NAME_RULES, null)) != null) {
                KerberosName.setRules(nameRules);
            }
            for (String spnegoPrincipal : spnegoPrincipals) {
                LOG.info("Login using keytab {}, for principal {}", (Object)this.keytab, (Object)spnegoPrincipal);
                KerberosConfiguration kerberosConfiguration = new KerberosConfiguration(this.keytab, spnegoPrincipal);
                LoginContext loginContext = new LoginContext("", this.serverSubject, null, kerberosConfiguration);
                try {
                    loginContext.login();
                }
                catch (LoginException le) {
                    LOG.warn("Failed to login as [{}]", (Object)spnegoPrincipal, (Object)le);
                    throw new AuthenticationException(le);
                }
                this.loginContexts.add(loginContext);
            }
            this.trustedProxyEnabled = Boolean.parseBoolean(config.getProperty(ENABLE_TRUSTED_PROXY));
            if (this.trustedProxyEnabled) {
                this.proxyUserAuthorization = new ProxyUserAuthorization(config);
            }
            try {
                this.gssManager = Subject.doAs(this.serverSubject, new PrivilegedExceptionAction<GSSManager>(){

                    @Override
                    public GSSManager run() throws Exception {
                        return GSSManager.getInstance();
                    }
                });
            }
            catch (PrivilegedActionException ex) {
                throw ex.getException();
            }
        }
        catch (Exception ex) {
            throw new ServletException((Throwable)ex);
        }
    }

    @Override
    public void destroy() {
        this.keytab = null;
        this.serverSubject = null;
        for (LoginContext loginContext : this.loginContexts) {
            try {
                loginContext.logout();
            }
            catch (LoginException ex) {
                LOG.warn(ex.getMessage(), (Throwable)ex);
            }
        }
        this.loginContexts.clear();
    }

    @Override
    public String getType() {
        return this.type;
    }

    protected Set<KerberosPrincipal> getPrincipals() {
        return this.serverSubject.getPrincipals(KerberosPrincipal.class);
    }

    protected String getKeytab() {
        return this.keytab;
    }

    @Override
    public boolean managementOperation(AuthenticationToken token, HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationException {
        return true;
    }

    @Override
    public AuthenticationToken authenticate(final HttpServletRequest request, final HttpServletResponse response) throws IOException, AuthenticationException {
        AuthenticationToken token = null;
        String authorization = request.getHeader("Authorization");
        if (authorization == null || !authorization.startsWith("Negotiate")) {
            response.setHeader("WWW-Authenticate", "Negotiate");
            response.setStatus(401);
            if (authorization == null) {
                LOG.trace("SPNEGO starting");
            } else {
                LOG.warn("'Authorization' does not start with 'Negotiate' :  {}", (Object)authorization);
            }
        } else {
            authorization = authorization.substring("Negotiate".length()).trim();
            final byte[] clientToken = Base64.getDecoder().decode(authorization);
            final String serverName = request.getServerName();
            try {
                token = Subject.doAs(this.serverSubject, new PrivilegedExceptionAction<AuthenticationToken>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public AuthenticationToken run() throws Exception {
                        AuthenticationToken token = null;
                        GSSContext gssContext = null;
                        GSSCredential gssCreds = null;
                        try {
                            gssCreds = KerberosAuthenticationHandler.this.gssManager.createCredential(KerberosAuthenticationHandler.this.gssManager.createName(KerberosUtil.getServicePrincipal("HTTP", serverName), KerberosUtil.getOidInstance("NT_GSS_KRB5_PRINCIPAL")), Integer.MAX_VALUE, new Oid[]{KerberosUtil.getOidInstance("GSS_SPNEGO_MECH_OID"), KerberosUtil.getOidInstance("GSS_KRB5_MECH_OID")}, 2);
                            gssContext = KerberosAuthenticationHandler.this.gssManager.createContext(gssCreds);
                            byte[] serverToken = gssContext.acceptSecContext(clientToken, 0, clientToken.length);
                            if (serverToken != null && serverToken.length > 0) {
                                String authenticate = Base64.getEncoder().encodeToString(serverToken);
                                response.setHeader("WWW-Authenticate", "Negotiate " + authenticate);
                            }
                            if (!gssContext.isEstablished()) {
                                response.setStatus(401);
                                LOG.trace("SPNEGO in progress");
                            } else {
                                String clientPrincipal = gssContext.getSrcName().toString();
                                KerberosName kerberosName = new KerberosName(clientPrincipal);
                                String userName = kerberosName.getShortName();
                                String doAsUser = null;
                                if (KerberosAuthenticationHandler.this.trustedProxyEnabled && (doAsUser = KerberosAuthenticationHandler.getDoasUser(request)) != null) {
                                    if (!KerberosAuthenticationHandler.this.proxyUserAuthorization.authorize(userName, request.getRemoteAddr())) {
                                        LOG.info("{} is not authorized to act as proxy user from {}", (Object)userName, (Object)request.getRemoteAddr());
                                        response.setStatus(401);
                                        AuthenticationToken authenticationToken = null;
                                        return authenticationToken;
                                    }
                                    clientPrincipal = userName = doAsUser;
                                }
                                token = new AuthenticationToken(userName, clientPrincipal, KerberosAuthenticationHandler.this.getType());
                                response.setStatus(200);
                                LOG.trace("SPNEGO completed for principal [{}]", (Object)clientPrincipal);
                            }
                        }
                        finally {
                            if (gssContext != null) {
                                gssContext.dispose();
                            }
                            if (gssCreds != null) {
                                gssCreds.dispose();
                            }
                        }
                        return token;
                    }
                });
            }
            catch (PrivilegedActionException ex) {
                if (ex.getException() instanceof IOException) {
                    throw (IOException)ex.getException();
                }
                throw new AuthenticationException(ex.getException());
            }
        }
        return token;
    }

    @Override
    public boolean shouldAuthenticate(HttpServletRequest request) {
        boolean isSSOEnabled = false;
        if (request.getAttribute("jwtSSOEnabled") != null && Boolean.TRUE.toString().equals(request.getAttribute("jwtSSOEnabled"))) {
            isSSOEnabled = true;
        }
        LOG.debug("isSSOEnabled is " + isSSOEnabled);
        return !Utils.isBrowser(this.nonBrowserUserAgents, request) || !isSSOEnabled;
    }

    protected static String getDoasUser(HttpServletRequest request) {
        String doAsUser = "";
        String queryString = request.getQueryString();
        if (queryString != null) {
            String[] pairs = queryString.split(QUERY_STRING_DELIMITER);
            try {
                for (String pair : pairs) {
                    if (!pair.startsWith(DOAS_QUERY_STRING)) continue;
                    doAsUser = URLDecoder.decode(pair.substring(DOAS_QUERY_STRING.length()), "UTF-8").trim();
                }
            }
            catch (UnsupportedEncodingException ex) {
                LOG.error("Invalid encoding provided.");
            }
        }
        return doAsUser.isEmpty() ? null : doAsUser;
    }

    class ProxyUserAuthorization {
        static final String PROXYUSER_REGEX_PATTERN = "proxyuser\\.(.+)\\.hosts";
        static final String DELIMITER = "\\s*,\\s*";
        private Map<String, List<String>> proxyUserHostsMap = new HashMap<String, List<String>>();

        ProxyUserAuthorization(Properties config) {
            Pattern pattern = Pattern.compile(PROXYUSER_REGEX_PATTERN);
            config.stringPropertyNames().forEach(propertyName -> {
                Matcher matcher = pattern.matcher((CharSequence)propertyName);
                if (matcher.find()) {
                    String proxyUser = matcher.group(1);
                    String hostList = config.getProperty((String)propertyName).trim();
                    List<Object> hosts = hostList.equals("*") ? new ArrayList() : Arrays.asList(hostList.split(DELIMITER));
                    this.proxyUserHostsMap.put(proxyUser, hosts);
                }
            });
        }

        public boolean authorize(String proxyUser, String host) {
            List<String> proxyHosts = this.proxyUserHostsMap.get(proxyUser);
            if (proxyHosts == null) {
                return false;
            }
            if (proxyHosts.isEmpty()) {
                return true;
            }
            return proxyHosts.contains(host);
        }
    }

    private static class KerberosConfiguration
    extends Configuration {
        private String keytab;
        private String principal;

        public KerberosConfiguration(String keytab, String principal) {
            this.keytab = keytab;
            this.principal = principal;
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
            HashMap<String, String> options = new HashMap<String, String>();
            if (PlatformName.IBM_JAVA) {
                options.put("useKeytab", this.keytab.startsWith("file://") ? this.keytab : "file://" + this.keytab);
                options.put("principal", this.principal);
                options.put("credsType", "acceptor");
            } else {
                options.put("keyTab", this.keytab);
                options.put("principal", this.principal);
                options.put("useKeyTab", "true");
                options.put("storeKey", "true");
                options.put("doNotPrompt", "true");
                options.put("useTicketCache", "true");
                options.put("renewTGT", "true");
                options.put("isInitiator", "false");
            }
            options.put("refreshKrb5Config", "true");
            String ticketCache = System.getenv("KRB5CCNAME");
            if (ticketCache != null) {
                if (PlatformName.IBM_JAVA) {
                    options.put("useDefaultCcache", "true");
                    System.setProperty("KRB5CCNAME", ticketCache);
                    options.put("renewTGT", "true");
                    options.put("credsType", "both");
                } else {
                    options.put("ticketCache", ticketCache);
                }
            }
            if (LOG.isDebugEnabled()) {
                options.put("debug", "true");
            }
            return new AppConfigurationEntry[]{new AppConfigurationEntry(KerberosUtil.getKrb5LoginModuleName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options)};
        }
    }
}

