/*
 * Decompiled with CFR 0.152.
 */
package com.hortonworks.registries.auth.util;

import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger LOG = LoggerFactory.getLogger(Utils.class);

    public static Thread newThread(String name, Runnable runnable, boolean daemon) {
        Thread thread = new Thread(runnable, name);
        thread.setDaemon(daemon);
        thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                LOG.error("Uncaught exception in thread '" + t.getName() + "':", e);
            }
        });
        return thread;
    }

    public static String[] getNonBrowserUserAgents(String nonBrowserUserAgentsConfig) {
        String[] result = nonBrowserUserAgentsConfig.split("\\W*,\\W*");
        for (int i = 0; i < result.length; ++i) {
            result[i] = result[i].toLowerCase(Locale.ENGLISH);
        }
        return result;
    }

    public static boolean isBrowser(String[] nonBrowserUserAgents, HttpServletRequest request) {
        String userAgent = request.getHeader("User-Agent");
        LOG.debug("User agent is " + userAgent);
        if (userAgent == null) {
            return false;
        }
        userAgent = userAgent.toLowerCase(Locale.ENGLISH);
        boolean isBrowser = true;
        for (String nonBrowserUserAgent : nonBrowserUserAgents) {
            if (!userAgent.contains(nonBrowserUserAgent)) continue;
            isBrowser = false;
            break;
        }
        return isBrowser;
    }

    public static boolean isBlank(CharSequence cs) {
        if (cs == null || cs.length() == 0) {
            return true;
        }
        int strLen = cs.length();
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

