/*
 * Decompiled with CFR 0.152.
 */
package com.hortonworks.registries.auth.client;

import com.hortonworks.registries.auth.client.AuthenticatedURL;
import com.hortonworks.registries.auth.client.AuthenticationException;
import com.hortonworks.registries.auth.client.Authenticator;
import com.hortonworks.registries.auth.client.ConnectionConfigurator;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;

public class PseudoAuthenticator
implements Authenticator {
    public static final String USER_NAME = "user.name";
    private static final String USER_NAME_EQ = "user.name=";
    private ConnectionConfigurator connConfigurator;

    @Override
    public void setConnectionConfigurator(ConnectionConfigurator configurator) {
        this.connConfigurator = configurator;
    }

    @Override
    public void authenticate(URL url, AuthenticatedURL.Token token) throws IOException, AuthenticationException {
        String strUrl = url.toString();
        String paramSeparator = strUrl.contains("?") ? "&" : "?";
        strUrl = strUrl + paramSeparator + USER_NAME_EQ + this.getUserName();
        url = new URL(strUrl);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        if (this.connConfigurator != null) {
            conn = this.connConfigurator.configure(conn);
        }
        conn.setRequestMethod("OPTIONS");
        conn.connect();
        AuthenticatedURL.extractToken(conn, token);
    }

    protected String getUserName() {
        return System.getProperty(USER_NAME);
    }
}

