/*
 * Decompiled with CFR 0.152.
 */
package com.hortonworks.registries.auth.server;

import com.hortonworks.registries.auth.client.AuthenticationException;
import com.hortonworks.registries.auth.server.AuthenticationToken;
import com.hortonworks.registries.auth.server.KerberosAuthenticationHandler;
import com.hortonworks.registries.auth.util.KerberosName;
import com.hortonworks.registries.auth.util.Utils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collection;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.kerberos.authentication.KerberosAuthenticationProvider;
import org.springframework.security.kerberos.authentication.KerberosClient;
import org.springframework.security.kerberos.authentication.sun.SunJaasKerberosClient;

public class KerberosBasicAuthenticationHandler
extends KerberosAuthenticationHandler {
    public static final String LOGIN_ENABLED_CONFIG = "login.enabled";
    public static final String SPNEGO_ENABLED_CONFIG = "spnego.enabled";
    public static final String TYPE = "kerberos-login";
    public static final String AUTHORIZATION_HEADER = "Authorization";
    public static final String BASIC_AUTHENTICATION = "Basic";
    private static final Logger LOG = LoggerFactory.getLogger(KerberosBasicAuthenticationHandler.class);
    private static final String HTTP_LOGIN_METHOD = "POST";
    private KerberosAuthenticationProvider provider;
    private boolean spnegoEnabled;

    KerberosBasicAuthenticationHandler() {
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void init(Properties config) throws ServletException {
        this.spnegoEnabled = Boolean.parseBoolean(config.getProperty(SPNEGO_ENABLED_CONFIG, Boolean.TRUE.toString()));
        if (this.spnegoEnabled) {
            super.init(config);
        }
        try {
            this.provider = new KerberosAuthenticationProvider();
            SunJaasKerberosClient client = new SunJaasKerberosClient();
            if (LOG.isDebugEnabled()) {
                client.setDebug(true);
            }
            this.provider.setKerberosClient((KerberosClient)client);
            this.provider.setUserDetailsService((UserDetailsService)new KerberosUserDetailsService());
        }
        catch (Exception ex) {
            LOG.error("Failed to initialize the Kerberos Login Authentication Handler.", (Throwable)ex);
            throw new ServletException((Throwable)ex);
        }
    }

    @Override
    public void destroy() {
    }

    @Override
    public AuthenticationToken authenticate(HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationException {
        AuthenticationToken token = null;
        try {
            token = this.kerberosLogin(request, response);
        }
        catch (Exception ex) {
            LOG.error("Exception while attempting Basic Authentication.", (Throwable)ex);
        }
        if (token == null && this.spnegoEnabled) {
            LOG.debug("Attempting SPNEGO authentication sequence as kerberos login failed.");
            token = super.authenticate(request, response);
        }
        return token;
    }

    private AuthenticationToken kerberosLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (this.provider == null) {
            LOG.error("The Kerberos authentication provider is not initialized.");
            response.setStatus(401);
            return null;
        }
        String authorization = request.getHeader(AUTHORIZATION_HEADER);
        if (!(request.getMethod().equals(HTTP_LOGIN_METHOD) && request.isSecure() && authorization != null && authorization.startsWith(BASIC_AUTHENTICATION))) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Kerberos Login is not attempted because method: {}, secure: {}, authorization is empty: {}", new Object[]{request.getMethod(), request.isSecure(), authorization == null || authorization.isEmpty()});
            }
            response.setStatus(401);
            return null;
        }
        String credentials = authorization.split(BASIC_AUTHENTICATION)[1].trim();
        byte[] credentialsArray = Base64.getDecoder().decode(credentials);
        String[] principalAndPassword = new String(credentialsArray, StandardCharsets.UTF_8).split(":");
        if (principalAndPassword.length != 2) {
            LOG.error("Login credentials of invalid length is passed to the Authorization header {}.", (Object)principalAndPassword.length);
            response.setStatus(401);
            return null;
        }
        String rawPrincipal = principalAndPassword[0];
        String password = principalAndPassword[1];
        KerberosName kerberosName = new KerberosName(rawPrincipal);
        String identity = this.getUserIdentity(kerberosName, rawPrincipal);
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)identity, (Object)password);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created authentication token for principal {} with name {} and is authenticated {}", new Object[]{token.getPrincipal(), token.getName(), token.isAuthenticated()});
        }
        Authentication authentication = null;
        try {
            authentication = this.provider.authenticate((Authentication)token);
        }
        catch (BadCredentialsException ex) {
            LOG.debug("Bad credentials provided", (Throwable)ex);
        }
        catch (org.springframework.security.core.AuthenticationException ex) {
            LOG.error("Kerberos login failed.", (Throwable)ex);
        }
        if (authentication == null) {
            response.setStatus(401);
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Ran provider.authenticate() and returned authentication for principal {} with name {} and is authenticated {}", new Object[]{authentication.getPrincipal(), authentication.getName(), authentication.isAuthenticated()});
        }
        response.setStatus(200);
        return new AuthenticationToken(kerberosName.getShortName(), authentication.getName(), this.getType());
    }

    private String getUserIdentity(KerberosName kerberosName, String rawPrincipal) {
        String identity;
        boolean realmInRawPrincipal;
        String defaultRealm = kerberosName.getDefaultRealm();
        boolean bl = realmInRawPrincipal = !Utils.isBlank(kerberosName.getRealm());
        if (realmInRawPrincipal) {
            identity = rawPrincipal;
            LOG.debug("Realm was specified in principal {}, default realm was not added to the identity being authenticated", (Object)rawPrincipal);
        } else if (!Utils.isBlank(defaultRealm)) {
            identity = rawPrincipal + "@" + defaultRealm;
            LOG.debug("Realm was not specified in principal {}, default realm {} was added to the identity being authenticated", (Object)rawPrincipal, (Object)defaultRealm);
        } else {
            identity = rawPrincipal;
            LOG.debug("Realm was not specified in principal {}, default realm is blank and was not added to the identity being authenticated", (Object)rawPrincipal);
        }
        return identity;
    }

    class KerberosUserDetailsService
    implements UserDetailsService {
        KerberosUserDetailsService() {
        }

        public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
            return new User(username, "notUsed", true, true, true, true, (Collection)AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_USER"}));
        }
    }
}

