/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal.utils;

import com.obs.services.internal.utils.CRC64;
import java.io.IOException;
import java.io.InputStream;

public class CRC64InputStream
extends InputStream {
    private final InputStream inputStream;
    private final CRC64 crc64;

    public CRC64 getCrc64() {
        return this.crc64;
    }

    public CRC64InputStream(InputStream inputStream) {
        this.inputStream = inputStream;
        this.crc64 = new CRC64();
    }

    @Override
    public int read() throws IOException {
        int byteRead = this.inputStream.read();
        if (byteRead != -1) {
            this.crc64.update(byteRead);
        }
        return byteRead;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int bytesRead = this.inputStream.read(b, off, len);
        if (bytesRead != -1) {
            this.crc64.update(b, off, bytesRead);
        }
        return bytesRead;
    }

    @Override
    public long skip(long n) throws IOException {
        long totalSkippedBytes;
        long skippedBytes;
        byte[] buffer = new byte[512];
        for (totalSkippedBytes = 0L; totalSkippedBytes < n; totalSkippedBytes += skippedBytes) {
            long remainBytesToSkip = n - totalSkippedBytes;
            skippedBytes = this.read(buffer, 0, remainBytesToSkip < (long)buffer.length ? (int)remainBytesToSkip : buffer.length);
            if (skippedBytes != -1L) continue;
            return totalSkippedBytes;
        }
        return totalSkippedBytes;
    }

    @Override
    public int available() throws IOException {
        return this.inputStream.available();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.inputStream.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this.inputStream.markSupported();
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
        super.close();
    }
}

