/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.debug;

import java.util.Objects;
import org.antlr.v4.runtime.ParserRuleContext;
import org.beetl.core.BlockEnvContext;
import org.beetl.core.ProgramBuilderContext;
import org.beetl.core.VarDescription;
import org.beetl.core.debug.DebugBlockEnvContext;
import org.beetl.core.debug.DebugVarDescription;
import org.beetl.core.statement.ASTNode;
import org.beetl.core.statement.Statement;

public class DebugProgramBuilderContext
extends ProgramBuilderContext {
    @Override
    protected void varIndexPoint(BlockEnvContext blockEnvContext, VarDescription vd, int index) {
        DebugVarDescription debugVarDescription = (DebugVarDescription)vd;
        int declareLine = debugVarDescription.getLine();
        String varName = debugVarDescription.getVarName();
        VarPoint varPoint = new VarPoint(varName, declareLine, index);
        DebugBlockEnvContext debugBlockEnvContext = (DebugBlockEnvContext)blockEnvContext;
        debugBlockEnvContext.getSet().add(varPoint);
    }

    @Override
    public VarDescription addVar(ASTNode varNode) {
        DebugVarDescription debugVarDescription = (DebugVarDescription)super.addVar(varNode);
        debugVarDescription.setLine(varNode.token.line);
        return debugVarDescription;
    }

    @Override
    public BlockEnvContext newBlockEnvContext() {
        return new DebugBlockEnvContext();
    }

    @Override
    public VarDescription newVarDescription() {
        return new DebugVarDescription();
    }

    @Override
    public void enterBlock(ParserRuleContext ruleContext) {
        super.enterBlock(ruleContext);
        int startLine = ruleContext.getStart().getLine();
        int endLine = ruleContext.getStop().getLine();
        ((DebugBlockEnvContext)this.current).setBlockStartLine(startLine);
        ((DebugBlockEnvContext)this.current).setBlockEndLine(endLine);
    }

    @Override
    public void exitBlock(Statement statement) {
        super.exitBlock(statement);
    }

    public static class VarPoint {
        String varName;
        int declareLine;
        int index;

        public VarPoint(String varName, int declareLine, int index) {
            this.varName = varName;
            this.declareLine = declareLine;
            this.index = index;
        }

        public String getVarName() {
            return this.varName;
        }

        public void setVarName(String varName) {
            this.varName = varName;
        }

        public int getDeclareLine() {
            return this.declareLine;
        }

        public void setDeclareLine(int declareLine) {
            this.declareLine = declareLine;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            VarPoint varPoint = (VarPoint)o;
            return this.declareLine == varPoint.declareLine && Objects.equals(this.varName, varPoint.varName);
        }

        public int hashCode() {
            return Objects.hash(this.varName, this.declareLine);
        }
    }
}

