/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.script;

import java.io.IOException;
import java.io.Reader;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.beetl.core.Configuration;
import org.beetl.core.GroupTemplate;
import org.beetl.core.Script;
import org.beetl.core.exception.ErrorInfo;
import org.beetl.core.resource.ClasspathResourceLoader;
import org.beetl.core.resource.StringTemplateResourceLoader;
import org.beetl.core.script.BeetlScriptContext;
import org.beetl.core.script.BeetlScriptEngineFactory;
import org.beetl.core.script.BeetlScriptException;

public class BeetlScriptEngine
extends AbstractScriptEngine {
    BeetlScriptEngineFactory factory;
    GroupTemplate groupTemplate;
    StringTemplateResourceLoader loader = new StringTemplateResourceLoader();

    public BeetlScriptEngine(BeetlScriptEngineFactory factory) {
        this.factory = factory;
        ClasspathResourceLoader resourceLoader = new ClasspathResourceLoader("/");
        Configuration cfg = null;
        try {
            cfg = Configuration.defaultConfiguration();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        cfg.setStatementStart("@");
        cfg.setStatementEnd(null);
        this.groupTemplate = new GroupTemplate(resourceLoader, cfg);
    }

    @Override
    public Object eval(String strScript, ScriptContext context) throws ScriptException {
        Script script = this.groupTemplate.getScript(strScript, this.loader);
        script.binding(context.getBindings(100));
        script.execute();
        if (!script.isSuccess()) {
            ErrorInfo errorInfo = script.getErrorInfo();
            throw new BeetlScriptException(errorInfo, (Exception)errorInfo.getCause());
        }
        return script.getResult();
    }

    public Script getScript(String strScript) {
        Script script = this.groupTemplate.getScript(strScript, this.loader);
        return script;
    }

    @Override
    public Object eval(Reader reader, ScriptContext context) throws ScriptException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Bindings createBindings() {
        return new SimpleBindings();
    }

    @Override
    public ScriptEngineFactory getFactory() {
        return this.factory;
    }

    @Override
    protected ScriptContext getScriptContext(Bindings nn) {
        BeetlScriptContext beetlScriptContext = new BeetlScriptContext();
        beetlScriptContext.setBindings(nn, 0);
        return beetlScriptContext;
    }
}

