/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.statement;

import java.util.LinkedHashMap;
import org.beetl.core.Context;
import org.beetl.core.exception.BeetlException;
import org.beetl.core.statement.Expression;
import org.beetl.core.statement.GrammarToken;
import org.beetl.core.statement.Statement;
import org.beetl.core.statement.TagStatement;
import org.beetl.core.statement.VarDefineNode;
import org.beetl.core.tag.HTMLTagVarBindingWrapper;
import org.beetl.core.tag.Tag;

public class TagVarBindingStatement
extends TagStatement {
    protected VarDefineNode[] varIndexs;

    public TagVarBindingStatement(String tagName, Expression[] paras, Statement block, VarDefineNode[] varDefine, GrammarToken token) {
        super(tagName, paras, block, token);
        this.varIndexs = varDefine;
    }

    @Override
    protected void runTag(Tag tag, Context ctx) {
        try {
            if (!(tag instanceof HTMLTagVarBindingWrapper)) {
                BeetlException be = new BeetlException("ERROR", "tag\u5fc5\u987b\u662fHTMLTagVarBindingWrapper");
                be.pushToken(this.token);
                throw be;
            }
            HTMLTagVarBindingWrapper htmlTag = (HTMLTagVarBindingWrapper)tag;
            LinkedHashMap<String, Integer> indexMap = new LinkedHashMap<String, Integer>(this.varIndexs.length);
            for (VarDefineNode node : this.varIndexs) {
                indexMap.put(node.token.text, node.varIndex);
            }
            htmlTag.mapName2Index(indexMap);
            tag.render();
            tag.afterRender();
        }
        catch (BeetlException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            BeetlException be = new BeetlException("ERROR", "tag\u6267\u884c\u629b\u9519", ex);
            be.pushToken(this.token);
            throw be;
        }
    }
}

