/*
 * Decompiled with CFR 0.152.
 */
package winter.com.ideaaedi.classwinter;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.lang.management.ManagementFactory;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.ZipFile;
import winter.com.ideaaedi.classwinter.exception.ClassWinterException;
import winter.com.ideaaedi.classwinter.executor.DecryptExecutor;
import winter.com.ideaaedi.classwinter.util.Cache;
import winter.com.ideaaedi.classwinter.util.ExceptionUtil;
import winter.com.ideaaedi.classwinter.util.IOUtil;
import winter.com.ideaaedi.classwinter.util.JVMUtil;
import winter.com.ideaaedi.classwinter.util.JarUtil;
import winter.com.ideaaedi.classwinter.util.JavaagentCmdArgs;
import winter.com.ideaaedi.classwinter.util.Logger;
import winter.com.ideaaedi.classwinter.util.Pair;
import winter.com.ideaaedi.classwinter.util.StrUtil;

public class Reverses {
    private static JavaagentCmdArgs javaagentCmdArgs = null;

    public static void premain(String args, Instrumentation instrumentation) {
        block10: {
            if (javaagentCmdArgs == null) {
                try {
                    javaagentCmdArgs = JavaagentCmdArgs.parseJavaagentCmdArgs(args);
                    Logger.debug(Reverses.class, "Parse raw javaagent args [" + args + "] to javaagentCmdArgs -> " + javaagentCmdArgs);
                }
                catch (Exception e) {
                    Logger.error(Reverses.class, ExceptionUtil.getStackTraceMessage(e));
                    Reverses.exit(null);
                }
                Logger.ENABLE_DEBUG.set(javaagentCmdArgs.isDebug());
            }
            try {
                long structs = JVMUtil.getSymbol("gHotSpotVMStructs");
                JVMUtil.putAddress(structs, 0L);
                Logger.debug(Reverses.class, "Disabled VM Structs");
            }
            catch (Throwable e) {
                Logger.warn(Reverses.class, "Disabled VM Structs fail. " + e.getMessage());
                if (!Logger.ENABLE_DEBUG.get()) break block10;
                Logger.debug(Reverses.class, ExceptionUtil.getStackTraceMessage(e));
            }
        }
        final HashSet<String> skipProjectPathPrefixSet = new HashSet<String>();
        String skipProjectPathPrefix = javaagentCmdArgs.getSkipProjectPathPrefix();
        if (!StrUtil.isBlank(skipProjectPathPrefix)) {
            String[] projectPathItem;
            for (String projectPathPrefix : projectPathItem = skipProjectPathPrefix.split("___")) {
                if (StrUtil.isBlank(projectPathPrefix)) continue;
                skipProjectPathPrefixSet.add(projectPathPrefix.trim().replace("\\", "/"));
            }
        }
        Logger.debug(Reverses.class, "skipProjectPathPrefixSet -> " + skipProjectPathPrefixSet);
        final HashSet<String> decryptProjectPathPrefixSet = new HashSet<String>();
        String decryptProjectPathPrefix = javaagentCmdArgs.getDecryptProjectPathPrefix();
        if (!StrUtil.isBlank(decryptProjectPathPrefix)) {
            String[] projectPathItem;
            for (String projectPathPrefix : projectPathItem = decryptProjectPathPrefix.split("___")) {
                if (StrUtil.isBlank(projectPathPrefix)) continue;
                decryptProjectPathPrefixSet.add(projectPathPrefix.trim().replace("\\", "/"));
            }
        }
        Logger.debug(Reverses.class, "decryptProjectPathPrefixSet -> " + decryptProjectPathPrefixSet);
        final AtomicBoolean firstExec = new AtomicBoolean(false);
        final CopyOnWriteArraySet projectPathSet = new CopyOnWriteArraySet();
        if (instrumentation != null) {
            instrumentation.addTransformer(new ClassFileTransformer(){

                @Override
                public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
                    boolean settingDecryptProjectPath;
                    if (className == null || protectionDomain == null || loader == null) {
                        return classfileBuffer;
                    }
                    String projectPath = protectionDomain.getCodeSource().getLocation().getPath();
                    try {
                        projectPath = URLDecoder.decode(projectPath, StandardCharsets.UTF_8.name());
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                    try {
                        projectPath = JarUtil.getRootPath(projectPath);
                    }
                    catch (ClassWinterException e) {
                        if (Reverses.notPointToDecrypt(projectPath, decryptProjectPathPrefixSet)) {
                            return classfileBuffer;
                        }
                    }
                    catch (Exception e) {
                        Logger.warn(Reverses.class, "JarUtil.getRootPath occur exception. projectPath -> " + projectPath + ", e.getMessage() -> " + e.getMessage());
                        return classfileBuffer;
                    }
                    if (projectPath != null && projectPath.startsWith("nested:/") && (projectPath = projectPath.substring("nested:/".length())).endsWith("/") && projectPath.length() > 1) {
                        projectPath = projectPath.substring(0, projectPath.length() - 1);
                    }
                    if (projectPath != null && !projectPath.startsWith("/") && !Reverses.isWindows()) {
                        projectPath = "/" + projectPath;
                    }
                    if (!projectPathSet.contains(projectPath)) {
                        Logger.debug(Reverses.class, "Exist projectPath -> " + projectPath);
                        projectPathSet.add(projectPath);
                    }
                    if (StrUtil.isEmpty(projectPath)) {
                        return classfileBuffer;
                    }
                    for (String skipProjectPathPrefix : skipProjectPathPrefixSet) {
                        if (!projectPath.startsWith(skipProjectPathPrefix)) continue;
                        return classfileBuffer;
                    }
                    boolean bl = settingDecryptProjectPath = decryptProjectPathPrefixSet.size() > 0;
                    if (settingDecryptProjectPath && Reverses.notPointToDecrypt(projectPath, decryptProjectPathPrefixSet)) {
                        return classfileBuffer;
                    }
                    className = className.replace("/", ".").replace("\\", ".");
                    Reverses.extractSeal(projectPath);
                    String inputPwd = javaagentCmdArgs.getPassword();
                    if (firstExec.compareAndSet(false, true)) {
                        try {
                            byte[] jvmArgCheckBytes = IOUtil.readFileFromWorkbenchRoot(new File(projectPath), "META-INF/winter/jscf.winter");
                            if (jvmArgCheckBytes == null) {
                                throw new IllegalStateException("jvmArgCheckBytes should not be null.");
                            }
                            jvmArgCheckBytes = DecryptExecutor.decrypt(projectPath, null, Base64.getDecoder().decode(jvmArgCheckBytes), inputPwd == null ? null : inputPwd.toCharArray());
                            String jvmArgCheck = new String(jvmArgCheckBytes, StandardCharsets.UTF_8);
                            Logger.debug(Reverses.class, "jvmArgCheck is -> " + jvmArgCheck);
                            if (StrUtil.isBlank(jvmArgCheck)) {
                                throw new IllegalStateException("jvmArgCheck should not be blank.");
                            }
                            if (!"NON_CHECK_ITEM_AT_CLASS-WINTER".equals(jvmArgCheck)) {
                                List<String> inputArguments = ManagementFactory.getRuntimeMXBean().getInputArguments();
                                Logger.debug(Reverses.class, "Parse jvm args -> " + inputArguments);
                                Arrays.stream(jvmArgCheck.split(" ")).filter(str -> !StrUtil.isBlank(str)).forEach(jvmItem -> {
                                    boolean containTargetArg = false;
                                    for (String inputArgument : inputArguments) {
                                        if (!jvmItem.equalsIgnoreCase(inputArgument)) continue;
                                        containTargetArg = true;
                                        break;
                                    }
                                    if (!containTargetArg) {
                                        throw new IllegalArgumentException("Miss jvm arg -> " + jvmItem);
                                    }
                                });
                            }
                        }
                        catch (Exception e) {
                            Logger.error(Reverses.class, "jvm-arg-check fail.");
                            Logger.error(Reverses.class, ExceptionUtil.getStackTraceMessage(e));
                            Reverses.exit(projectPath);
                            for (int i = 0; i < 10; ++i) {
                                Logger.error(Reverses.class, "!!!!!!!!!!! class-winter Invalidation. !!!!!!!!!!!");
                            }
                            return null;
                        }
                        try {
                            Map<String, Pair<byte[], byte[]>> resultMap = DecryptExecutor.unMaskNonClassFiles(projectPath, inputPwd == null ? null : inputPwd.toCharArray());
                            HashMap tmpMap = new HashMap(16);
                            resultMap.forEach((k, v) -> {
                                byte[] cfr_ignored_0 = (byte[])tmpMap.put(k, v.getLeft());
                            });
                            String finalProjectPath = projectPath;
                            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                                try {
                                    Logger.debug(Reverses.class, "mask non-class files start.");
                                    JarUtil.rewriteZipEntry(new ZipFile(finalProjectPath), tmpMap);
                                    Logger.debug(Reverses.class, "mask non-class files end.");
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }));
                        }
                        catch (Exception e) {
                            Logger.error(Reverses.class, ExceptionUtil.getStackTraceMessage(e));
                            Logger.error(Reverses.class, "Decrypt non-classes fail. ");
                            Reverses.exit(projectPath);
                            for (int i = 0; i < 10; ++i) {
                                Logger.error(Reverses.class, "!!!!!!!!!!! class-winter Invalidation. !!!!!!!!!!!");
                            }
                            return null;
                        }
                    }
                    if (DecryptExecutor.checklistContain(projectPath, className) && DecryptExecutor.verifySeal(projectPath, classfileBuffer)) {
                        try {
                            Logger.debug(Reverses.class, "Decrypt class[" + className + "] start.");
                            classfileBuffer = DecryptExecutor.process(projectPath, null, className, inputPwd == null ? null : inputPwd.toCharArray());
                            Logger.debug(Reverses.class, "Decrypt class[" + className + "] end.");
                            return classfileBuffer;
                        }
                        catch (Exception e) {
                            Logger.error(Reverses.class, ExceptionUtil.getStackTraceMessage(e));
                            Logger.error(Reverses.class, "Decrypt class[" + className + "] fail. " + (StrUtil.isEmpty(inputPwd) ? e.getMessage() : "Please ensure your password is correct."));
                            Reverses.exit(projectPath);
                            for (int i = 0; i < 10; ++i) {
                                Logger.error(Reverses.class, "!!!!!!!!!!! class-winter Invalidation. !!!!!!!!!!!");
                            }
                            return null;
                        }
                    }
                    if (DecryptExecutor.checklistOfAllLibsContain(projectPath, className) && DecryptExecutor.verifyLibSeal(projectPath, className, classfileBuffer)) {
                        String classWinterInfoDir = DecryptExecutor.getLibDirRelativePath(className);
                        try {
                            Logger.debug(Reverses.class, "Decrypt class[" + className + "] start.");
                            classfileBuffer = DecryptExecutor.process(projectPath, classWinterInfoDir, className, null);
                            Logger.debug(Reverses.class, "Decrypt class[" + className + "] end.");
                            return classfileBuffer;
                        }
                        catch (Exception e) {
                            Logger.error(Reverses.class, ExceptionUtil.getStackTraceMessage(e));
                            String lib = DecryptExecutor.parseLib(classWinterInfoDir);
                            Logger.error(Reverses.class, "Decrypt class[" + className + "] fail. \nPlease check:\n\t1. Ensure 'Your lib " + lib + " need a input password ?'\n\t2. Ensure 'Your lib " + lib + "'s password is correct ?'");
                            Reverses.exit(projectPath);
                            for (int i = 0; i < 10; ++i) {
                                Logger.error(Reverses.class, "!!!!!!!!!!! class-winter Invalidation. !!!!!!!!!!!");
                            }
                            return null;
                        }
                    }
                    return classfileBuffer;
                }
            });
        }
    }

    private static void extractSeal(String projectPath) {
        block8: {
            if (Cache.sealCache.containsKey(projectPath)) {
                return;
            }
            try {
                byte[] sealByte = IOUtil.readFileFromWorkbenchRoot(new File(projectPath), "META-INF/winter/seal.winter");
                String sealContent = null;
                if (sealByte == null) {
                    if (Cache.firstSealCache != null) {
                        sealContent = Cache.firstSealCache;
                        Logger.debug(Reverses.class, "Use first-seal as curr project seal.");
                    }
                } else {
                    sealContent = new String(sealByte, StandardCharsets.UTF_8);
                    Logger.debug(Reverses.class, "direct-seal of the project is -> " + sealContent);
                }
                if (sealContent == null) {
                    Logger.error(Reverses.class, "Obtain project seal fail.");
                    Reverses.exit(projectPath);
                }
                Cache.sealCache.put(projectPath, sealContent);
                if (Cache.firstSealCache != null) break block8;
                Cache.firstSealCache = sealContent;
                Cache.firstSealProjectPath = projectPath;
                Logger.debug(Reverses.class, "first-seal found. projectPath -> " + Cache.firstSealProjectPath);
                Logger.debug(Reverses.class, "first-seal found. sealContent -> " + Cache.firstSealCache);
            }
            catch (Exception e) {
                Logger.error(Reverses.class, "Obtain project seal fail.");
                Logger.error(Reverses.class, ExceptionUtil.getStackTraceMessage(e));
                Reverses.exit(projectPath);
                for (int i = 0; i < 10; ++i) {
                    Logger.error(Reverses.class, "!!!!!!!!!!! class-winter Invalidation. !!!!!!!!!!!");
                }
            }
        }
    }

    private static boolean notPointToDecrypt(String projectPath, Set<String> decryptProjectPathPrefixSet) {
        boolean notNeedTryDecrypt = true;
        for (String decryptProjectPathPrefix : decryptProjectPathPrefixSet) {
            if (projectPath == null || !projectPath.startsWith(decryptProjectPathPrefix)) continue;
            notNeedTryDecrypt = false;
            break;
        }
        return notNeedTryDecrypt;
    }

    private static void exit(String projectPath) {
        try {
            if (projectPath != null) {
                Logger.error(Reverses.class, "Curr projectPath is -> " + projectPath);
            }
            TimeUnit.SECONDS.sleep(10L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.exit(-1);
    }

    public static boolean isWindows() {
        return Optional.ofNullable(System.getProperty("os.name")).map(String::toLowerCase).map(x -> x.contains("windows")).orElse(false);
    }
}

