/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures.validation.lotl;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.commons.utils.TimerUtil;
import com.itextpdf.io.resolver.resource.DefaultResourceRetriever;
import com.itextpdf.io.resolver.resource.IResourceRetriever;
import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.signatures.validation.TrustedCertificatesStore;
import com.itextpdf.signatures.validation.lotl.CountrySpecificLotlFetcher;
import com.itextpdf.signatures.validation.lotl.EuropeanLotlFetcher;
import com.itextpdf.signatures.validation.lotl.EuropeanResourceFetcher;
import com.itextpdf.signatures.validation.lotl.InMemoryLotlServiceCache;
import com.itextpdf.signatures.validation.lotl.LotlCacheDataV1;
import com.itextpdf.signatures.validation.lotl.LotlFetchingProperties;
import com.itextpdf.signatures.validation.lotl.LotlServiceCache;
import com.itextpdf.signatures.validation.lotl.LotlValidator;
import com.itextpdf.signatures.validation.lotl.PivotFetcher;
import com.itextpdf.signatures.validation.lotl.XmlSignatureValidator;
import com.itextpdf.signatures.validation.report.ReportItem;
import com.itextpdf.signatures.validation.report.ValidationReport;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.function.Function;
import java.util.function.LongUnaryOperator;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LotlService
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(LotlService.class);
    private static final Object GLOBAL_SERVICE_LOCK = new Object();
    static LotlService GLOBAL_SERVICE;
    private final LotlFetchingProperties lotlFetchingProperties;
    private LotlServiceCache cache;
    private EuropeanResourceFetcher europeanResourceFetcher = new EuropeanResourceFetcher();
    private EuropeanLotlFetcher lotlByteFetcher;
    private PivotFetcher pivotFetcher;
    private CountrySpecificLotlFetcher countrySpecificLotlFetcher;
    private boolean cacheInitialized = false;
    private Timer cacheTimer = null;
    private IResourceRetriever resourceRetriever = new LoggableResourceRetriever();
    private Function<TrustedCertificatesStore, XmlSignatureValidator> xmlSignatureValidatorFactory;
    private Supplier<LotlValidator> lotlValidatorFactory;

    public LotlService(LotlFetchingProperties lotlFetchingProperties) {
        this.lotlFetchingProperties = lotlFetchingProperties;
        this.cache = new InMemoryLotlServiceCache(lotlFetchingProperties.getCacheStalenessInMilliseconds(), lotlFetchingProperties.getOnCountryFetchFailureStrategy());
        this.lotlByteFetcher = new EuropeanLotlFetcher(this);
        this.pivotFetcher = new PivotFetcher(this);
        this.countrySpecificLotlFetcher = new CountrySpecificLotlFetcher(this);
        this.xmlSignatureValidatorFactory = trustedCertificatesStore -> LotlService.buildXmlSignatureValidator(trustedCertificatesStore);
        this.lotlValidatorFactory = () -> this.buildLotlValidator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initializeGlobalCache(LotlFetchingProperties lotlFetchingProperties) {
        Object object = GLOBAL_SERVICE_LOCK;
        synchronized (object) {
            if (GLOBAL_SERVICE != null) {
                throw new PdfException("Global LOTL service has already been initialized. You cannot initialize it again. If you want to use a different configuration, please create a new instance of LotlService with the desired properties and use it in ValidatorChainBuilder.");
            }
            GLOBAL_SERVICE = new LotlService(lotlFetchingProperties);
            GLOBAL_SERVICE.initializeCache();
        }
    }

    public static LotlService getGlobalService() {
        return GLOBAL_SERVICE;
    }

    public LotlService withLotlServiceCache(LotlServiceCache cache) {
        this.cache = cache;
        return this;
    }

    public final LotlService withCustomResourceRetriever(IResourceRetriever resourceRetriever) {
        this.resourceRetriever = resourceRetriever;
        return this;
    }

    public void initializeCache() {
        this.initializeCache(null);
    }

    public void initializeCache(InputStream stream) {
        this.setupTimer();
        if (stream != null) {
            this.loadFromCache(stream);
        } else {
            this.loadFromNetwork();
        }
        this.cacheInitialized = true;
    }

    public void loadFromCache(InputStream stream) {
        try {
            LotlCacheDataV1 container = LotlCacheDataV1.deserialize(stream);
            if (this.cache instanceof InMemoryLotlServiceCache) {
                Map<String, Long> newTimeStamps = container.getTimeStamps();
                InMemoryLotlServiceCache inMemoryCache = (InMemoryLotlServiceCache)this.cache;
                HashMap<String, Long> currentTimeStamps = inMemoryCache.getTimeStamps();
                for (Map.Entry<String, Long> entry : newTimeStamps.entrySet()) {
                    Long newTimeStamp = entry.getValue();
                    Long timeStampFromCache = (Long)currentTimeStamps.get(entry.getKey());
                    if (timeStampFromCache == null || newTimeStamp > timeStampFromCache) continue;
                    throw new PdfException("Incoming data is older than the data already in cache. Cache was not updated.");
                }
                inMemoryCache.setTimeStamps(container.getTimeStamps());
            }
            EuropeanLotlFetcher.Result mainLotlResult = container.getLotlCache();
            EuropeanResourceFetcher.Result europeanResourceFetcherEUJournalCertificates = container.getEuropeanResourceFetcherCache();
            PivotFetcher.Result pivotsResult = container.getPivotCache();
            Map<String, CountrySpecificLotlFetcher.Result> resultToAddToCache = container.getCountrySpecificLotlCache();
            if (mainLotlResult == null || europeanResourceFetcherEUJournalCertificates == null || pivotsResult == null || resultToAddToCache == null) {
                throw new PdfException("Could not initialize LotlService from output stream. Regenerate the file using LotlService#serializeCache method.");
            }
            HashSet<String> countriesInCache = new HashSet<String>();
            for (String key : new ArrayList<String>(resultToAddToCache.keySet())) {
                CountrySpecificLotlFetcher.Result value = resultToAddToCache.get(key);
                String countryCode = value.getCountrySpecificLotl().getSchemeTerritory();
                if (this.lotlFetchingProperties.getSchemaNames().contains(countryCode) || this.lotlFetchingProperties.getSchemaNames().isEmpty()) {
                    countriesInCache.add(countryCode);
                    continue;
                }
                resultToAddToCache.remove(key);
                LOGGER.warn(MessageFormatUtil.format((String)"Country \"{0}\" is not required by lotlFetchingProperties, and not be used when validating.", (Object[])new Object[]{countryCode}));
            }
            for (String schemaName : this.lotlFetchingProperties.getSchemaNames()) {
                if (countriesInCache.contains(schemaName)) continue;
                throw new PdfException(MessageFormatUtil.format((String)"Initialized cache does not contain data for required country: {0}. This might happen if the country was not included in the LotlFetchingProperties when serializing the data.", (Object[])new Object[]{schemaName}));
            }
            this.cache.setAllValues(mainLotlResult, europeanResourceFetcherEUJournalCertificates, pivotsResult, resultToAddToCache);
        }
        catch (PdfException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PdfException("Could not initialize LotlService from output stream. Regenerate the file using LotlService#serializeCache method.", (Throwable)e);
        }
    }

    public LotlService withPivotFetcher(PivotFetcher pivotFetcher) {
        this.pivotFetcher = pivotFetcher;
        return this;
    }

    public LotlService withCountrySpecificLotlFetcher(CountrySpecificLotlFetcher countrySpecificLotlFetcher) {
        this.countrySpecificLotlFetcher = countrySpecificLotlFetcher;
        return this;
    }

    public LotlService withEuropeanLotlFetcher(EuropeanLotlFetcher fetcher) {
        this.lotlByteFetcher = fetcher;
        return this;
    }

    public LotlService withXmlSignatureValidator(Function<TrustedCertificatesStore, XmlSignatureValidator> xmlSignatureValidatorFactory) {
        this.xmlSignatureValidatorFactory = xmlSignatureValidatorFactory;
        return this;
    }

    public LotlService withLotlValidator(Supplier<LotlValidator> lotlValidatorFactory) {
        this.lotlValidatorFactory = lotlValidatorFactory;
        return this;
    }

    public LotlService withEuropeanResourceFetcher(EuropeanResourceFetcher europeanResourceFetcher) {
        this.europeanResourceFetcher = europeanResourceFetcher;
        return this;
    }

    @Override
    public void close() {
        this.cancelTimer();
    }

    public void serializeCache(OutputStream outputStream) throws IOException {
        if (!(this.cache instanceof InMemoryLotlServiceCache)) {
            throw new PdfException("Cannot serialize cache, timestamp data is not available. This can happen if a custom implementation of LotlServiceCache is used which does not support stale tracking. You should override the serialization method in that case.");
        }
        InMemoryLotlServiceCache inMemoryCache = (InMemoryLotlServiceCache)this.cache;
        inMemoryCache.getAllData().serialize(outputStream);
    }

    protected void loadFromNetwork() {
        EuropeanLotlFetcher.Result mainLotlResult = this.lotlByteFetcher.fetch();
        if (!mainLotlResult.getLocalReport().getFailures().isEmpty()) {
            ReportItem reportItem = mainLotlResult.getLocalReport().getFailures().get(0);
            throw new PdfException(reportItem.getMessage(), (Throwable)reportItem.getExceptionCause());
        }
        EuropeanResourceFetcher.Result europeanResourceFetcherEUJournalCertificates = this.europeanResourceFetcher.getEUJournalCertificates();
        this.pivotFetcher.setCurrentJournalUri(europeanResourceFetcherEUJournalCertificates.getCurrentlySupportedPublication());
        PivotFetcher.Result pivotsResult = this.pivotFetcher.downloadAndValidatePivotFiles(mainLotlResult.getLotlXml(), europeanResourceFetcherEUJournalCertificates.getCertificates());
        if (!pivotsResult.getLocalReport().getFailures().isEmpty()) {
            ReportItem failure = pivotsResult.getLocalReport().getFailures().get(0);
            throw new PdfException(failure.getMessage(), (Throwable)failure.getExceptionCause());
        }
        Map<String, CountrySpecificLotlFetcher.Result> countrySpecificResults = this.countrySpecificLotlFetcher.getAndValidateCountrySpecificLotlFiles(mainLotlResult.getLotlXml(), this);
        HashMap<String, CountrySpecificLotlFetcher.Result> resultToAddToCache = new HashMap<String, CountrySpecificLotlFetcher.Result>(countrySpecificResults.size());
        for (Map.Entry<String, CountrySpecificLotlFetcher.Result> entry : countrySpecificResults.entrySet()) {
            CountrySpecificLotlFetcher.Result countrySpecificResult = entry.getValue();
            if (countrySpecificResult.getLocalReport().getValidationResult() != ValidationReport.ValidationResult.VALID) {
                for (ReportItem log : countrySpecificResult.getLocalReport().getLogs()) {
                    log.setStatus(ReportItem.ReportItemStatus.INFO);
                }
                this.lotlFetchingProperties.getOnCountryFetchFailureStrategy().onCountryFailure(countrySpecificResult);
            }
            resultToAddToCache.put(entry.getKey(), countrySpecificResult);
        }
        this.cache.setAllValues(mainLotlResult, europeanResourceFetcherEUJournalCertificates, pivotsResult, resultToAddToCache);
    }

    protected void setupTimer() {
        long staleNessInMillis = this.lotlFetchingProperties.getCacheStalenessInMilliseconds();
        TimerUtil.stopTimer((Timer)this.cacheTimer);
        LongUnaryOperator cacheRefreshTimer = this.lotlFetchingProperties.getRefreshIntervalCalculator();
        long refreshInterval = cacheRefreshTimer.applyAsLong(staleNessInMillis);
        this.cacheTimer = TimerUtil.newTimerWithRecurringTask(() -> this.tryAndRefreshCache(), (long)refreshInterval, (long)refreshInterval);
    }

    protected void cancelTimer() {
        if (this.cacheTimer != null) {
            TimerUtil.stopTimer((Timer)this.cacheTimer);
        }
    }

    protected void tryAndRefreshCache() {
        Map<String, CountrySpecificLotlFetcher.Result> allCountries;
        EuropeanResourceFetcher.Result europeanResourceFetcherEUJournalCertificatesToUse;
        String currentJournalUri;
        EuropeanLotlFetcher.Result mainLotlResultToUse = null;
        PivotFetcher.Result pivotResultToUse = null;
        try {
            EuropeanResourceFetcher.Result europeanResourceFetcherEUJournalCertificates = this.europeanResourceFetcher.getEUJournalCertificates();
            currentJournalUri = europeanResourceFetcherEUJournalCertificates.getCurrentlySupportedPublication();
            if (europeanResourceFetcherEUJournalCertificates.getLocalReport().getValidationResult() != ValidationReport.ValidationResult.VALID) {
                LOGGER.warn(MessageFormatUtil.format((String)"Problem occurred while fetching EU Journal certificates.\n{0}", (Object[])new Object[]{europeanResourceFetcherEUJournalCertificates.getLocalReport().getFailures().get(0).getMessage()}));
                return;
            }
            europeanResourceFetcherEUJournalCertificatesToUse = europeanResourceFetcherEUJournalCertificates;
        }
        catch (Exception e) {
            LOGGER.warn(MessageFormatUtil.format((String)"Problem occurred while fetching EU Journal certificates.\n{0}", (Object[])new Object[]{e.getMessage()}));
            return;
        }
        boolean mainLotlFetchSuccessful = false;
        Exception mainLotlFetchException = null;
        try {
            mainLotlResultToUse = this.lotlByteFetcher.fetch();
            mainLotlFetchSuccessful = mainLotlResultToUse.hasValidXml() && mainLotlResultToUse.getLocalReport().getFailures().isEmpty();
        }
        catch (Exception e) {
            mainLotlFetchException = e;
        }
        boolean fetchPivotFilesSuccessful = false;
        Exception pivotFetchException = null;
        if (mainLotlFetchSuccessful) {
            try {
                this.pivotFetcher.setCurrentJournalUri(currentJournalUri);
                pivotResultToUse = this.pivotFetcher.downloadAndValidatePivotFiles(mainLotlResultToUse.getLotlXml(), this.europeanResourceFetcher.getEUJournalCertificates().getCertificates());
                fetchPivotFilesSuccessful = pivotResultToUse.getLocalReport().getValidationResult() == ValidationReport.ValidationResult.VALID;
            }
            catch (Exception e) {
                pivotFetchException = e;
            }
        } else {
            LOGGER.warn(MessageFormatUtil.format((String)"Unable to update cache with main Lotl file. Downloading of the main Lotl file failed.\n{0}", (Object[])new Object[]{mainLotlFetchException == null ? "" : mainLotlFetchException.getMessage()}));
        }
        if (!fetchPivotFilesSuccessful) {
            LOGGER.warn(MessageFormatUtil.format((String)"Unable to pivot files because of pivot file fetching failure.\n{0}", (Object[])new Object[]{pivotFetchException == null ? "" : pivotFetchException.getMessage()}));
        }
        if (!mainLotlFetchSuccessful) {
            return;
        }
        try {
            allCountries = this.countrySpecificLotlFetcher.getAndValidateCountrySpecificLotlFiles(mainLotlResultToUse.getLotlXml(), this);
        }
        catch (Exception e) {
            LOGGER.warn(MessageFormatUtil.format((String)"Problem occurred while fetching country specific Lotl files.\n{0}", (Object[])new Object[]{e.getMessage()}));
            return;
        }
        if (allCountries == null || allCountries.isEmpty()) {
            LOGGER.warn("Zero country specific Lotl files were fetched.");
            return;
        }
        HashMap<String, CountrySpecificLotlFetcher.Result> countrySpecificLotlResultsToUse = new HashMap<String, CountrySpecificLotlFetcher.Result>(allCountries.size());
        for (CountrySpecificLotlFetcher.Result countrySpecificResult : allCountries.values()) {
            boolean wasCountryFetchedSuccessfully = countrySpecificResult.getLocalReport().getFailures().isEmpty();
            if (!wasCountryFetchedSuccessfully) {
                LOGGER.warn(MessageFormatUtil.format((String)"Country specific Lotl fetching with schema name \"{0}\" failed because of:\n \"{1}\"", (Object[])new Object[]{countrySpecificResult.getCountrySpecificLotl().getSchemeTerritory(), countrySpecificResult.getLocalReport()}));
                continue;
            }
            countrySpecificLotlResultsToUse.put(countrySpecificResult.createUniqueIdentifier(), countrySpecificResult);
        }
        if (pivotResultToUse == null) {
            return;
        }
        this.cache.setAllValues(mainLotlResultToUse, europeanResourceFetcherEUJournalCertificatesToUse, pivotResultToUse, countrySpecificLotlResultsToUse);
    }

    PivotFetcher.Result getAndValidatePivotFiles(byte[] lotlXml, List<Certificate> certificates, String currentJournalUri) {
        PivotFetcher.Result result = this.cache.getPivotResult();
        if (result != null) {
            return result;
        }
        this.pivotFetcher.setCurrentJournalUri(currentJournalUri);
        PivotFetcher.Result newResult = this.pivotFetcher.downloadAndValidatePivotFiles(lotlXml, certificates);
        this.cache.setPivotResult(newResult);
        return newResult;
    }

    List<CountrySpecificLotlFetcher.Result> getCountrySpecificLotlFiles(byte[] lotlXml) {
        Map<String, CountrySpecificLotlFetcher.Result> result = this.cache.getCountrySpecificLotls();
        if (result != null) {
            return new ArrayList<CountrySpecificLotlFetcher.Result>(result.values());
        }
        Map<String, CountrySpecificLotlFetcher.Result> countrySpecificLotlResults = this.countrySpecificLotlFetcher.getAndValidateCountrySpecificLotlFiles(lotlXml, this);
        for (Map.Entry<String, CountrySpecificLotlFetcher.Result> s : countrySpecificLotlResults.entrySet()) {
            boolean successful;
            boolean bl = successful = s.getValue().getLocalReport().getValidationResult() == ValidationReport.ValidationResult.VALID;
            if (!successful && !s.getValue().getLocalReport().getLogs().isEmpty()) continue;
            this.cache.setCountrySpecificLotlResult(s.getValue());
        }
        return new ArrayList<CountrySpecificLotlFetcher.Result>(countrySpecificLotlResults.values());
    }

    boolean isCacheInitialized() {
        return this.cacheInitialized;
    }

    HashMap<String, CountrySpecificLotlFetcher.Result> getCachedCountrySpecificLotls() {
        return new HashMap<String, CountrySpecificLotlFetcher.Result>(this.cache.getCountrySpecificLotls());
    }

    EuropeanLotlFetcher.Result getLotlBytes() {
        EuropeanLotlFetcher.Result cachedData = this.cache.getLotlResult();
        if (cachedData != null) {
            return cachedData;
        }
        EuropeanLotlFetcher.Result data = this.lotlByteFetcher.fetch();
        this.cache.setLotlResult(data);
        return data;
    }

    EuropeanResourceFetcher.Result getEUJournalCertificates() {
        EuropeanResourceFetcher.Result cachedResult = this.cache.getEUJournalCertificates();
        if (cachedResult != null) {
            return cachedResult;
        }
        EuropeanResourceFetcher.Result result = this.europeanResourceFetcher.getEUJournalCertificates();
        this.cache.setEuropeanResourceFetcherResult(result);
        return result;
    }

    IResourceRetriever getResourceRetriever() {
        return this.resourceRetriever;
    }

    XmlSignatureValidator getXmlSignatureValidator(TrustedCertificatesStore trustedCertificatesStore) {
        return this.xmlSignatureValidatorFactory.apply(trustedCertificatesStore);
    }

    LotlFetchingProperties getLotlFetchingProperties() {
        return this.lotlFetchingProperties;
    }

    LotlValidator getLotlValidator() {
        return this.lotlValidatorFactory.get();
    }

    private LotlValidator buildLotlValidator() {
        return new LotlValidator(this);
    }

    private static XmlSignatureValidator buildXmlSignatureValidator(TrustedCertificatesStore trustedCertificatesStore) {
        return new XmlSignatureValidator(trustedCertificatesStore);
    }

    private static final class LoggableResourceRetriever
    extends DefaultResourceRetriever {
        private static final Logger LOGGER = LoggerFactory.getLogger(LotlService.class);

        public byte[] getByteArrayByUrl(URL url) throws IOException {
            LOGGER.info(MessageFormatUtil.format((String)"Fetching resource from URL: {0}", (Object[])new Object[]{url}));
            return super.getByteArrayByUrl(url);
        }
    }
}

