/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures.validation.lotl;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.signatures.validation.SafeCalling;
import com.itextpdf.signatures.validation.TrustedCertificatesStore;
import com.itextpdf.signatures.validation.lotl.CertificateSelector;
import com.itextpdf.signatures.validation.lotl.XmlValidationUtils;
import com.itextpdf.signatures.validation.report.CertificateReportItem;
import com.itextpdf.signatures.validation.report.ReportItem;
import com.itextpdf.signatures.validation.report.ValidationReport;
import java.io.InputStream;
import java.security.cert.X509Certificate;

public class XmlSignatureValidator {
    static final String XML_SIGNATURE_VERIFICATION = "XML Signature verification check.";
    static final String XML_SIGNATURE_VERIFICATION_EXCEPTION = "XML Signature verification threw exception. Validation wasn't successful.";
    static final String NO_CERTIFICATE = "XML signing certificate wasn't find in the document. Validation wasn't successful.";
    static final String XML_SIGNATURE_VERIFICATION_FAILED = "XML Signature verification wasn't successful. Signature is invalid.";
    static final String CERTIFICATE_TRUSTED = "Certificate {0} is trusted. Validation is successful.";
    static final String CERTIFICATE_NOT_TRUSTED = "Certificate {0} is NOT trusted. Validation isn't successful.";
    private final TrustedCertificatesStore trustedCertificatesStore;

    protected XmlSignatureValidator(TrustedCertificatesStore trustedCertificatesStore) {
        this.trustedCertificatesStore = trustedCertificatesStore;
    }

    protected ValidationReport validate(InputStream xmlDocumentInputStream) {
        ValidationReport report = new ValidationReport();
        CertificateSelector keySelector = new CertificateSelector();
        SafeCalling.onExceptionLog(() -> {
            boolean coreValidity = XmlValidationUtils.createXmlDocumentAndCheckValidity(xmlDocumentInputStream, keySelector);
            if (!coreValidity) {
                report.addReportItem(new ReportItem(XML_SIGNATURE_VERIFICATION, XML_SIGNATURE_VERIFICATION_FAILED, ReportItem.ReportItemStatus.INVALID));
            }
        }, report, e -> new ReportItem(XML_SIGNATURE_VERIFICATION, XML_SIGNATURE_VERIFICATION_EXCEPTION, (Exception)e, ReportItem.ReportItemStatus.INVALID));
        if (report.getValidationResult() == ValidationReport.ValidationResult.INVALID) {
            return report;
        }
        if (keySelector.getCertificate() == null) {
            report.addReportItem(new ReportItem(XML_SIGNATURE_VERIFICATION, NO_CERTIFICATE, ReportItem.ReportItemStatus.INVALID));
            return report;
        }
        X509Certificate certificate = keySelector.getCertificate();
        if (this.trustedCertificatesStore.isCertificateGenerallyTrusted(certificate)) {
            report.addReportItem(new CertificateReportItem(certificate, XML_SIGNATURE_VERIFICATION, MessageFormatUtil.format((String)CERTIFICATE_TRUSTED, (Object[])new Object[]{certificate.getSubjectX500Principal()}), ReportItem.ReportItemStatus.INFO));
        } else {
            report.addReportItem(new CertificateReportItem(certificate, XML_SIGNATURE_VERIFICATION, MessageFormatUtil.format((String)CERTIFICATE_NOT_TRUSTED, (Object[])new Object[]{certificate.getSubjectX500Principal()}), ReportItem.ReportItemStatus.INVALID));
        }
        return report;
    }
}

