/*
 * Decompiled with CFR 0.152.
 */
package com.itmuch.wii;

import com.itmuch.wii.WiiChecker;
import com.itmuch.wii.WiiDiscoveryClient;
import com.itmuch.wii.WiiHealthIndicator;
import com.itmuch.wii.WiiProperties;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.web.client.RestTemplate;

@Configuration
@EnableConfigurationProperties(value={WiiProperties.class})
public class WiiAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public RestTemplate restTemplate() {
        return new RestTemplate();
    }

    @Bean
    public WiiHealthIndicator wiiHealthIndicator(WiiProperties wiiProperties, RestTemplate restTemplate) {
        return new WiiHealthIndicator(wiiProperties, restTemplate);
    }

    @Bean
    public WiiChecker wiiCleaner(WiiDiscoveryClient wiiDiscoveryClient, WiiHealthIndicator wiiHealthIndicator, WiiProperties wiiProperties, ConfigurableEnvironment environment) {
        WiiChecker cleaner = new WiiChecker(wiiDiscoveryClient, (HealthIndicator)wiiHealthIndicator, wiiProperties, environment);
        cleaner.check();
        return cleaner;
    }
}

