/*
 * Decompiled with CFR 0.152.
 */
package com.itmuch.wii;

import com.itmuch.wii.WiiDiscoveryClient;
import com.itmuch.wii.WiiProperties;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.actuate.health.Status;
import org.springframework.core.env.ConfigurableEnvironment;
import reactor.core.scheduler.Schedulers;

public class WiiChecker {
    private static final Logger log = LoggerFactory.getLogger(WiiChecker.class);
    private final WiiDiscoveryClient wiiDiscoveryClient;
    private final HealthIndicator healthIndicator;
    private final WiiProperties wiiProperties;
    private final ConfigurableEnvironment environment;

    public void check() {
        Schedulers.single().schedulePeriodically(() -> {
            String ip = this.wiiProperties.getIp();
            Integer port = this.wiiProperties.getPort();
            Status status = this.healthIndicator.health().getStatus();
            String applicationName = this.environment.getProperty("spring.application.name");
            if (status.equals((Object)Status.UP)) {
                this.wiiDiscoveryClient.registerInstance(applicationName, ip, port);
                log.debug("Health check success. register this instance. applicationName = {}, ip = {}, port = {}, status = {}", new Object[]{applicationName, ip, port, status});
            } else {
                log.warn("Health check failed. unregister this instance. applicationName = {}, ip = {}, port = {}, status = {}", new Object[]{applicationName, ip, port, status});
                this.wiiDiscoveryClient.deregisterInstance(applicationName, ip, port);
            }
        }, 0L, 30L, TimeUnit.SECONDS);
    }

    @Autowired
    public WiiChecker(WiiDiscoveryClient wiiDiscoveryClient, HealthIndicator healthIndicator, WiiProperties wiiProperties, ConfigurableEnvironment environment) {
        this.wiiDiscoveryClient = wiiDiscoveryClient;
        this.healthIndicator = healthIndicator;
        this.wiiProperties = wiiProperties;
        this.environment = environment;
    }
}

